/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.setup;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.SasObjectProperty;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.SasStrings;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.JobParameterUtils;
import com.sas.lsaf.macro.execution.job.SasParameterValues;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptors;
import com.sas.lsaf.macro.workflow.ProcessFlowElementHelper;
import com.sas.lsaf.macro.workflow.SasProcessFlowElementNotFoundException;
import com.sas.lsaf.macro.workflow.processflow.ProcessFlowUtils;
import com.sas.lsaf.macro.workflow.processflow.SasProcessFlowPropertiesResult;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowElementsParametersResult;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowElementsPrincipalsResult;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowElementsResult;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowSignalLocationsResult;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowTimerElement;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowTimerElementResult;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.processflow.setup.ElementSetup;
import com.sas.lsaf.workflow.processflow.setup.JobTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.NotificationTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.SignalEventSetup;
import com.sas.lsaf.workflow.processflow.setup.TaskSetup;
import com.sas.lsaf.workflow.processflow.setup.TimerEventSetup;
import com.sas.lsaf.workflow.processflow.setup.UserTaskSetup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessFlowSetupService {
    private static Log LOG = LogFactory.getLog(ProcessFlowSetupService.class);
    private static ProcessFlowSetupService FOR_COVERAGE = new ProcessFlowSetupService();

    private ProcessFlowSetupService() {
    }

    private static com.sas.lsaf.workflow.processflow.setup.ProcessFlowSetupService doGetService() {
        return ServiceManagerFactory.getApiProcessFlowSetupService();
    }

    private static List<ElementSetup> doGetElementsByType(String contextPath, String pfName, String elementType) throws Exception {
        String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
        Set elements = ProcessFlowSetupService.doGetService().getElementSetups(pfId);
        List<String> validTypes = ProcessFlowElementHelper.getValidElementTypes(elementType);
        ArrayList<ElementSetup> validElements = new ArrayList<ElementSetup>();
        for (ElementSetup ed : elements) {
            if (!validTypes.contains(ed.getType().name())) continue;
            validElements.add(ed);
        }
        return validElements;
    }

    private static ElementSetup doGetElementByTypeAndId(String contextPath, String pfName, String expectedType, String elementID) throws Exception {
        ValidationUtils.validateRequiredParameter(elementID, "Process flow element id");
        String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
        List<String> validTypes = ProcessFlowElementHelper.getValidElementTypes(expectedType);
        Set elements = ProcessFlowSetupService.doGetService().getElementSetups(pfId);
        for (ElementSetup es : elements) {
            if (!es.getElementId().equals(elementID) || !validTypes.contains(es.getType().name())) continue;
            return es;
        }
        throw new SasProcessFlowElementNotFoundException(expectedType, elementID);
    }

    public static void getAllSetupElements(String contextPath, String pfName, SasProcessFlowElementsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting setup elements for " + pfName + " in " + contextPath));
        }
        try {
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            Set elements = ProcessFlowSetupService.doGetService().getElementSetups(pfId);
            result.setElements(contextPath, pfName, elements);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getElementPropertiesByType(String contextPath, String pfName, String elementType, SasProcessFlowPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting setup elements properties for " + pfName + " in " + contextPath));
        }
        try {
            ArrayList<SasObjectProperty> properties = new ArrayList<SasObjectProperty>();
            List<ElementSetup> elements = ProcessFlowSetupService.doGetElementsByType(contextPath, pfName, elementType);
            for (ElementSetup ed : elements) {
                properties.addAll(ProcessFlowElementHelper.toSasObjectPropertyFromSetup(elementType, (TaskSetup)ed));
            }
            result.setPFProperties(contextPath, pfName, properties);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateElementProperties(String contextPath, String pfName, String elementID, String elementType, SasProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Update Job setup properties for element " + elementID + " for " + pfName + " in " + contextPath));
        }
        try {
            ElementSetup setup = ProcessFlowSetupService.doGetElementByTypeAndId(contextPath, pfName, elementType, elementID);
            PropertyUtils.updatePFSetupElementPropertiesByType((TaskSetup)setup, properties);
            ProcessFlowSetupService.doGetService().updateElementSetup(setup);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getElementPrincipalsByType(String contextPath, String pfName, String elementType, SasProcessFlowElementsPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting setup element principals for " + pfName + " in " + contextPath));
        }
        try {
            List<ElementSetup> elements = ProcessFlowSetupService.doGetElementsByType(contextPath, pfName, elementType);
            result.setPrincipals(ProcessFlowElementHelper.toSasPrincipalsFromElements(elements));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateElementPrincipals(String contextPath, String pfName, String elementID, String elementType, SasPrincipalDescriptors principals, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating setup element principals for " + elementID + " for " + pfName + " in " + contextPath));
        }
        try {
            Set<Object> pValues;
            ElementSetup ed = ProcessFlowSetupService.doGetElementByTypeAndId(contextPath, pfName, elementType, elementID);
            String elementNameType = ed instanceof UserTaskSetup ? "Candidate id" : "Recipient id";
            Set<Object> set = pValues = principals.getSize() == 0 ? new HashSet(0) : PrincipalUtils.convertSasPrincipalsToApiPrincipals(elementNameType, principals);
            if (ed.getType().equals((Object)Element.ElementType.USER_TASK)) {
                ((UserTaskSetup)ed).setCandidates(pValues);
            } else if (ed.getType().equals((Object)Element.ElementType.SYSTEM_NOTIFICATION)) {
                ((NotificationTaskSetup)ed).setRecipients(pValues);
            }
            ProcessFlowSetupService.doGetService().updateElementSetup(ed);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobElementsParameters(String contextPath, String pfName, SasProcessFlowElementsParametersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Job setup elements parameters for " + pfName + " in " + contextPath));
        }
        try {
            List<ElementSetup> elements = ProcessFlowSetupService.doGetElementsByType(contextPath, pfName, "JOB");
            result.setParameters(contextPath, pfName, ProcessFlowElementHelper.toSasPfParameterValues(elements));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateJobElementParameters(String contextPath, String pfName, String elementID, SasParameterValues parameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating Job setup element parameters for " + elementID + " for " + pfName + " in " + contextPath));
        }
        try {
            JobTaskSetup jobDef = (JobTaskSetup)ProcessFlowSetupService.doGetElementByTypeAndId(contextPath, pfName, "JOB", elementID);
            if (jobDef.getJobPath() == null) {
                throw new ResultException(-1, "Job task parameters cannot be updated when job path has not been set.");
            }
            List<Object> pValues = parameters.getSize() == 0 ? new ArrayList() : JobParameterUtils.toApiOverrideParameterValues(parameters);
            jobDef.setParameterValues(pValues);
            ProcessFlowSetupService.doGetService().updateElementSetup((ElementSetup)jobDef);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getSignalLocations(String contextPath, String pfName, SasProcessFlowSignalLocationsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Signal setup elements Locations for " + pfName + " in " + contextPath));
        }
        try {
            String elementType = Element.ElementType.INTERMEDIATE_CATCH_SIGNAL_EVENT.name();
            List<ElementSetup> elements = ProcessFlowSetupService.doGetElementsByType(contextPath, pfName, elementType);
            result.setLocations(contextPath, pfName, SasProcessFlowSignalLocationsResult.toSasSignalLocationsFromSignalElements(elements));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateSignalLocations(String contextPath, String pfName, String elementID, SasStrings locations, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating Signal setup element locations for " + elementID + " for " + pfName + " in " + contextPath));
        }
        try {
            SignalEventSetup sigDef = (SignalEventSetup)ProcessFlowSetupService.doGetElementByTypeAndId(contextPath, pfName, Element.ElementType.INTERMEDIATE_CATCH_SIGNAL_EVENT.name(), elementID);
            HashSet<String> paths = new HashSet<String>(locations.getList());
            sigDef.setLocations(paths);
            ProcessFlowSetupService.doGetService().updateElementSetup((ElementSetup)sigDef);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTimerElements(String contextPath, String pfName, SasProcessFlowTimerElementResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Timer setup elements for " + pfName + " in " + contextPath));
        }
        try {
            String elementType = Element.ElementType.INTERMEDIATE_CATCH_TIMER_EVENT.name();
            List<ElementSetup> elements = ProcessFlowSetupService.doGetElementsByType(contextPath, pfName, elementType);
            result.setElements(contextPath, pfName, SasProcessFlowTimerElementResult.toSasProcessFlowTimerElementsFromTimerSetups(elements));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateTimerElement(String contextPath, String pfName, String elementID, SasProcessFlowTimerElement sasTimer, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Update Timer setup element " + elementID + " for " + pfName + " in " + contextPath));
        }
        try {
            String elementType = Element.ElementType.INTERMEDIATE_CATCH_TIMER_EVENT.name();
            TimerEventSetup timerDef = (TimerEventSetup)ProcessFlowSetupService.doGetElementByTypeAndId(contextPath, pfName, elementType, elementID);
            Object newValue = null;
            if (TimerEventSetup.TimerType.DATE.equals((Object)timerDef.getTimerType())) {
                String sasDateValue = sasTimer.getTimerValue();
                newValue = ValidationUtils.validateDateString("Timer date", sasDateValue);
            } else {
                newValue = sasTimer.getDurationValueFromUnitValues();
                if (newValue.toString().length() < 3) {
                    throw new ResultException("At least one timer value must be greater than zero.");
                }
            }
            timerDef.setTimerValue((Serializable)newValue);
            ProcessFlowSetupService.doGetService().updateElementSetup((ElementSetup)timerDef);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

