/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.processflow;

import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.ProcessFlowService;

public final class ProcessFlowUtils {
    private static ProcessFlowUtils FOR_COVERAGE = new ProcessFlowUtils();
    public static final String MANIFEST_FILE_EXTENSION = ".pmnf";

    private ProcessFlowUtils() {
    }

    private static ProcessFlowService doGetService() {
        return ServiceManagerFactory.getApiProcessFlowService();
    }

    public static String getManifestFileName(String pfName) {
        return pfName + MANIFEST_FILE_EXTENSION;
    }

    public static ProcessFlow getProcessFlow(String contextPath, String pfName) throws Exception {
        ValidationUtils.assertRequiredPath(contextPath);
        ValidationUtils.validateRequiredParameter(pfName, "Process flow name");
        String ci = RepositoryUtils.getRepositoryItemId(contextPath);
        return ProcessFlowUtils.doGetService().getProcessFlowByNameAndContext(ci, pfName);
    }

    public static String getProcessFlowId(String contextPath, String pfName) throws Exception {
        return ProcessFlowUtils.getProcessFlow(contextPath, pfName).getId();
    }
}

