/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.processflow;

import com.sas.lsaf.content.common.FileCreateInfo;
import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasObjectProperties;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.workflow.SasDataPropertyResult;
import com.sas.lsaf.macro.workflow.processflow.ProcessFlowUtils;
import com.sas.lsaf.macro.workflow.processflow.SasProcessFlowPropertiesResult;
import com.sas.lsaf.macro.workflow.processflow.SasProcessFlowSearchResult;
import com.sas.lsaf.macro.workflow.processflow.SasProcessFlowsResult;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.processflow.CreationMethod;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyInfo;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.ProcessFlowQuery;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchResultItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessFlowService {
    static Log LOG = LogFactory.getLog(ProcessFlowService.class);
    private static ProcessFlowService FOR_COVERAGE = new ProcessFlowService();
    private static int searchPageSizeLimit = -1;

    private ProcessFlowService() {
    }

    private static com.sas.lsaf.workflow.processflow.ProcessFlowService doGetService() {
        return ServiceManagerFactory.getApiProcessFlowService();
    }

    private static CreationMethod doValidateCreationMethod(String value) {
        return (CreationMethod)ValidationUtils.validateNotRequiredEnum(value, "Creation method", CreationMethod.class, true);
    }

    private static boolean doValidateIncludeChildren(String value) {
        return ValidationUtils.validateBinaryFlagDefaultTrue(value, "Include children");
    }

    public static String copyProcessFlow(String contextPath, String pfName, String newProcessFlowName, String useSourceOwner, String includeAttachments, String includeProcessData, String activate, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Copying process flow " + pfName + " in " + contextPath + " to " + newProcessFlowName));
        }
        try {
            ValidationUtils.validateRequiredParameter(newProcessFlowName, "New name");
            boolean uso = ValidationUtils.validateBinaryFlagDefaultFalse(useSourceOwner, "Use source owner");
            boolean ia = ValidationUtils.validateBinaryFlagDefaultFalse(includeAttachments, "Include attachments");
            boolean ipd = ValidationUtils.validateBinaryFlagDefaultFalse(includeProcessData, "Include process data");
            boolean act = ValidationUtils.validateBinaryFlagDefaultFalse(activate, "Activate");
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            ProcessFlowCopyInfo pci = new ProcessFlowCopyInfo(newProcessFlowName, pfId, uso, ia, ipd, act);
            ProcessFlow newPf = ProcessFlowService.doGetService().copyProcessFlow(pci);
            result.init(0, "Success.");
            return newPf.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getProcessFlows(String contextPath, String includeChildren, SasProcessFlowsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting process flows for " + contextPath));
        }
        try {
            Set pfs = new HashSet();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)contextPath))) {
                pfs = ProcessFlowService.doGetService().getAllProcessFlowDescriptors();
            } else {
                boolean includeChildContexts = ProcessFlowService.doValidateIncludeChildren(includeChildren);
                String ci = RepositoryUtils.getRepositoryItemId(contextPath);
                pfs = ProcessFlowService.doGetService().getProcessFlowDescriptorsByContext(ci, includeChildContexts);
            }
            result.setProcessFlows(pfs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getMyProcessFlows(String contextPath, String includeChildren, SasProcessFlowsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting my process flows for " + contextPath));
        }
        try {
            Set pfs = new HashSet();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)contextPath))) {
                pfs = ProcessFlowService.doGetService().getMyProcessFlowDescriptors();
            } else {
                boolean includeChildContexts = ProcessFlowService.doValidateIncludeChildren(includeChildren);
                String ci = RepositoryUtils.getRepositoryItemId(contextPath);
                pfs = ProcessFlowService.doGetService().getMyProcessFlowDescriptorsByContext(ci, includeChildContexts);
            }
            result.setProcessFlows(pfs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean search(String status, String name, String contextPath, String processDefinitionKey, String owner, String lastModifiedBy, String fromLastModifiedDate, String toLastModifiedDate, String creationMethod, SasProcessFlowSearchResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting process flows by search criteria.");
        }
        com.sas.lsaf.workflow.processflow.ProcessFlowService srv = null;
        SearchResultsInfo info = null;
        try {
            int rowCount;
            ProcessFlowQuery query = new ProcessFlowQuery();
            query.setStatus((ProcessFlowDescriptor.FlowStatus)ValidationUtils.validateNotRequiredEnum(status, "Status", ProcessFlowDescriptor.FlowStatus.class, true));
            query.setName(ValidationUtils.toJavaString(name));
            query.setContextPath(ValidationUtils.toJavaString(contextPath));
            query.setProcessDefinitionKey(ValidationUtils.toJavaString(processDefinitionKey));
            query.setOwner(ValidationUtils.toJavaString(owner));
            query.setLastModifiedBy(ValidationUtils.toJavaString(lastModifiedBy));
            query.setFromLastModified(ValidationUtils.validateDateString("From last modified", fromLastModifiedDate));
            query.setToLastModified(ValidationUtils.validateDateString("TO last modified", toLastModifiedDate));
            query.setCreationMethod(ProcessFlowService.doValidateCreationMethod(creationMethod));
            srv = ServiceManagerFactory.getApiProcessFlowService();
            if (searchPageSizeLimit == -1) {
                searchPageSizeLimit = srv.getSearchPageSizeLimit();
            }
            if ((rowCount = (info = srv.search(query)).getRowCount()) > 0) {
                int first = 1;
                int last = rowCount <= searchPageSizeLimit ? rowCount : searchPageSizeLimit;
                ArrayList<ProcessFlowSearchResultItem> searchItems = new ArrayList<ProcessFlowSearchResultItem>();
                do {
                    List subSet = srv.getSearchResults(first, last);
                    searchItems.addAll(subSet);
                    first = last + 1;
                    int haveLeft = rowCount - last;
                    last = (haveLeft < searchPageSizeLimit ? first + haveLeft : first + searchPageSizeLimit) - 1;
                } while (first < rowCount);
                result.setProcessFlows(searchItems);
            }
            result.init(0, "Success.");
            boolean bl = info.isLimitReached();
            return bl;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            boolean bl = false;
            return bl;
        }
        finally {
            if (srv != null && info != null) {
                srv.clearSearchResults();
            }
        }
    }

    public static String create(String contextPath, String pfName, String processDefinitionKey, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating process flow " + pfName + " in " + contextPath));
        }
        try {
            ValidationUtils.assertRequiredPath(contextPath);
            ValidationUtils.validateRequiredParameter(pfName, "Process flow name");
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            String ci = RepositoryUtils.getRepositoryItemId(contextPath);
            ProcessFlow pf = ProcessFlowService.doGetService().createProcessFlow(ci, pfName, processDefinitionKey);
            result.init(0, "Success.");
            return pf.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void delete(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting " + pfName + " in " + contextPath));
        }
        try {
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            ProcessFlowService.doGetService().deleteProcessFlow(pfId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String createManifest(String contextPath, String pfName, SasFileCreateParameters fileInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating manifest for " + pfName + " in " + contextPath));
        }
        try {
            ValidationUtils.validateRequiredParameter(fileInfo.getPath(), "Manifest location");
            fileInfo.setPath(fileInfo.getPath() + "/" + ProcessFlowUtils.getManifestFileName(pfName));
            FileCreateInfo fci = ContentCreationParametersHelper.toFileCreateInfo(fileInfo);
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            String manifestPath = ProcessFlowService.doGetService().createProcessFlowManifest(pfId, fci);
            result.init(0, "Success.");
            return manifestPath == null ? "" : manifestPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static boolean exists(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of " + pfName + " in " + contextPath));
        }
        try {
            ValidationUtils.assertRequiredPath(contextPath);
            ValidationUtils.validateRequiredParameter(pfName, "Process flow name");
            String ci = RepositoryUtils.getRepositoryItemId(contextPath);
            boolean exists = ProcessFlowService.doGetService().exists(ci, pfName);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void activateProcessFlow(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating process flow " + pfName + " in " + contextPath));
        }
        try {
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            ProcessFlowService.doGetService().activateProcessFlow(pfId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void suspendProcessFlow(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suspending process flow " + pfName + " in " + contextPath));
        }
        try {
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            ProcessFlowService.doGetService().suspendProcessFlow(pfId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getProcessFlowId(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id for process flow " + pfName + " in " + contextPath));
        }
        try {
            String pfId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            result.init(0, "Success.");
            return pfId;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getProcessFlowStatus(String contextPath, String pfName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting status of process flow " + pfName + " in " + contextPath));
        }
        try {
            ProcessFlow pf = ProcessFlowUtils.getProcessFlow(contextPath, pfName);
            String status = pf.getStatus().name();
            result.init(0, "Success.");
            return status;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getProperties(String contextPath, String pfName, SasProcessFlowPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get process flow general informaton for " + pfName + " in " + contextPath));
        }
        try {
            ProcessFlow flow = ProcessFlowUtils.getProcessFlow(contextPath, pfName);
            SasObjectProperties spfProps = new SasObjectProperties();
            String type = AttributeDefinition.AttributeType.STRING.name();
            spfProps.addReadonlyRequiredProperty(null, "path", type, (Serializable)((Object)flow.getContextPath()));
            spfProps.addEditableRequiredProperty(null, "name", type, (Serializable)((Object)flow.getName()));
            spfProps.addEditableProperty(null, "description", type, (Serializable)((Object)flow.getDescription()));
            spfProps.addReadonlyRequiredProperty(null, "definitionID", type, (Serializable)((Object)flow.getProcessDefinitionInfo().getProcessDefinitionKey()));
            spfProps.addReadonlyRequiredProperty(null, "definitionVersion", type, (Serializable)((Object)flow.getProcessDefinitionInfo().getDeployedVersion()));
            spfProps.addEditableRequiredProperty(null, "owner", type, (Serializable)((Object)flow.getOwner()));
            spfProps.addReadonlyRequiredProperty(null, "status", type, (Serializable)flow.getStatus());
            AutoFlowType autoflowType = flow.getAutoFlowType();
            spfProps.addReadonlyProperty(null, "autoflowType", type, (Serializable)((Object)(autoflowType == null ? null : autoflowType.name())));
            spfProps.addReadonlyProperty(null, "autoflowSource", type, (Serializable)((Object)flow.getAutoFlowSource()));
            PropertyUtils.addObjectExtAttrsToProperties(spfProps, flow.getAttributes(), null, flow.getTypeId());
            result.setPFProperties(flow.getContextPath(), flow.getName(), spfProps.getProperties());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String updateProperties(String contextPath, String pfName, SasProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating process flow properties for " + pfName + "in context " + contextPath));
        }
        try {
            ProcessFlow flow = ProcessFlowUtils.getProcessFlow(contextPath, pfName);
            ValidationUtils.assertRequiredSasProperties(properties);
            PropertyUtils.updateIdentifiablePropertiesByType((AbstractIdentifiable)flow, flow.getAttributes(), properties);
            ProcessFlow updatedPF = ProcessFlowService.doGetService().updateProcessFlow(flow);
            result.init(0, "Success.");
            return updatedPF.getName();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return null;
        }
    }

    public static void getProcessFlowData(String contextPath, String pfName, SasDataPropertyResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get process flow data for " + pfName + " in " + contextPath));
        }
        try {
            ProcessFlow flow = ProcessFlowUtils.getProcessFlow(contextPath, pfName);
            result.setDataProperties(flow.getProcessData());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateProcessFlowData(String contextPath, String pfName, SasProperties pfData, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating process flow data for " + pfName + "in context " + contextPath));
        }
        try {
            ProcessFlow flow = ProcessFlowUtils.getProcessFlow(contextPath, pfName);
            ValidationUtils.assertRequiredSasProperties(pfData);
            for (SasProperty sasProp : pfData.getList()) {
                String propName = sasProp.getName();
                for (DataProperty dataProp : flow.getProcessData()) {
                    if (!dataProp.getId().equals(propName)) continue;
                    dataProp.setValue(ValidationUtils.toJavaSerializable(propName, sasProp.getValue(), dataProp.getType().name()));
                }
            }
            ProcessFlowService.doGetService().updateProcessFlow(flow);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

