/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.definition.mapping;

import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.workflow.definition.mapping.SasDefinitionElementNotFoundException;
import com.sas.lsaf.macro.workflow.definition.mapping.SasDefintionElementNotAutoflowMappableException;
import com.sas.lsaf.macro.workflow.definition.mapping.SasFlowElementMappings;
import com.sas.lsaf.macro.workflow.definition.mapping.SasProcessDefinitionElementMapping;
import com.sas.lsaf.workflow.AttributeMapping;
import com.sas.lsaf.workflow.AutoFlowMappingMetadata;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.FlowAttributeType;
import com.sas.lsaf.workflow.FlowElementMapping;
import com.sas.lsaf.workflow.MappingAttributeMetadata;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.processdefinition.FlowElementDefinition;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMappingMetadata;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService;
import com.sas.lsaf.workflow.processdefinition.TimerEventDefinition;
import com.sas.lsaf.workflow.processflow.setup.TimerEventSetup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SasProcessDefinitionAutoflowMetadataHelper {
    public static ProcessDefinitionService srv;
    private static Map<AutoFlowType, Map<Element.ElementType, List<MappingAttributeMetadata>>> definitionMetadata;

    private static List<SasProcessDefinitionElementMapping> doGetElementMappings(FlowElementDefinition element, ProcessDefinitionMapping processDefinitionMappings, List<MappingAttributeMetadata> autoFlowMetaDataMap) throws Exception {
        ArrayList<SasProcessDefinitionElementMapping> elementMappings = new ArrayList<SasProcessDefinitionElementMapping>();
        TimerEventSetup.TimerType timerType = element instanceof TimerEventDefinition ? ((TimerEventDefinition)element).getTimerType() : null;
        for (MappingAttributeMetadata mappableAttribute : autoFlowMetaDataMap) {
            for (AutoFlowMappingMetadata mappableValue : mappableAttribute.getMapAttributes()) {
                if (TimerEventSetup.TimerType.DATE.equals((Object)timerType) && !FlowAttributeType.DATE.equals((Object)mappableValue.getType()) || TimerEventSetup.TimerType.DURATION.equals((Object)timerType) && FlowAttributeType.DATE.equals((Object)mappableValue.getType())) continue;
                FlowElementMapping flowElementMapping = null;
                for (FlowElementMapping elementMapping : processDefinitionMappings.getElementMapping()) {
                    if (!elementMapping.getElementId().equals(element.getElementId())) continue;
                    flowElementMapping = elementMapping;
                    break;
                }
                boolean isMapped = false;
                if (flowElementMapping != null) {
                    for (AttributeMapping flowAttrMapping : flowElementMapping.getAttributeMapping()) {
                        if (!flowAttrMapping.getAttrName().equals(mappableAttribute.getAttrName()) || !flowAttrMapping.getMapAttrName().equals(mappableValue.getMapAttrName())) continue;
                        isMapped = true;
                        break;
                    }
                }
                elementMappings.add(new SasProcessDefinitionElementMapping(element.getElementId(), mappableAttribute, mappableValue, isMapped));
            }
        }
        return elementMappings;
    }

    private static Set<FlowElementDefinition> getProcessDefinitionElements(String processDefKey) throws Exception {
        ProcessDefinitionService srv = ServiceManagerFactory.getApiProcessDefinitionService();
        ProcessDefinitionInfo pdi = srv.getProcessDefinitionByKey(processDefKey);
        return srv.getProcessDefinitionElements(pdi.getId());
    }

    public static Map<Element.ElementType, List<MappingAttributeMetadata>> getMetadataMapByAutoFlowType(AutoFlowType type) throws Exception {
        if (definitionMetadata.isEmpty()) {
            List md = ServiceManagerFactory.getApiProcessDefinitionService().getProcessDefinitionMappingMetadata();
            for (ProcessDefinitionMappingMetadata a : md) {
                definitionMetadata.put(a.getType(), a.getMappingMetadata());
            }
        }
        return definitionMetadata.get(type);
    }

    public static List<SasProcessDefinitionElementMapping> toSasElementsFlowMappings(String specifiedElementId, ProcessDefinitionMapping processDefinitionMappings) throws Exception {
        ArrayList<SasProcessDefinitionElementMapping> elementMappings = new ArrayList<SasProcessDefinitionElementMapping>();
        Set<FlowElementDefinition> elements = SasProcessDefinitionAutoflowMetadataHelper.getProcessDefinitionElements(processDefinitionMappings.getProcessDefinitionKey());
        Map<Element.ElementType, List<MappingAttributeMetadata>> metaDataMap = SasProcessDefinitionAutoflowMetadataHelper.getMetadataMapByAutoFlowType(processDefinitionMappings.getType());
        boolean haveSpecifiedElement = !ValidationUtils.valueIsMissing((Serializable)((Object)specifiedElementId));
        boolean foundSpecifiedElement = false;
        for (FlowElementDefinition element : elements) {
            List<MappingAttributeMetadata> mappingAttributeMetadataList;
            if (haveSpecifiedElement) {
                if (!element.getElementId().equals(specifiedElementId)) continue;
                foundSpecifiedElement = true;
            }
            if ((mappingAttributeMetadataList = metaDataMap.get(element.getType())) == null) {
                if (!haveSpecifiedElement) continue;
                throw new SasDefintionElementNotAutoflowMappableException(element, processDefinitionMappings.getType(), metaDataMap.keySet());
            }
            elementMappings.addAll(SasProcessDefinitionAutoflowMetadataHelper.doGetElementMappings(element, processDefinitionMappings, mappingAttributeMetadataList));
            if (!foundSpecifiedElement) continue;
            break;
        }
        if (haveSpecifiedElement && !foundSpecifiedElement) {
            throw new SasDefinitionElementNotFoundException(specifiedElementId);
        }
        return elementMappings;
    }

    public static List<FlowElementMapping> toProcessDefinitionElementMappings(String processDefintionId, AutoFlowType autoflowType, SasFlowElementMappings sasMappingData) throws Exception {
        HashMap<String, FlowElementMapping> newMappings = new HashMap<String, FlowElementMapping>();
        Set<FlowElementDefinition> elements = SasProcessDefinitionAutoflowMetadataHelper.getProcessDefinitionElements(processDefintionId);
        if (elements == null || elements.isEmpty()) {
            throw new ResultException("Process defintion has no elements to process");
        }
        HashMap<String, FlowElementDefinition> elementMap = new HashMap<String, FlowElementDefinition>();
        for (FlowElementDefinition flowElementDefinition : elements) {
            elementMap.put(flowElementDefinition.getElementId(), flowElementDefinition);
        }
        Map<Element.ElementType, List<MappingAttributeMetadata>> metaDataMap = SasProcessDefinitionAutoflowMetadataHelper.getMetadataMapByAutoFlowType(autoflowType);
        for (SasFlowElementMappings.SasFlowElementMapping sasMapping : sasMappingData.getMappings()) {
            String elementId = sasMapping.getElementId();
            String attrName = sasMapping.getAttributeName();
            String mapAttrName = sasMapping.getMapAttrName();
            ValidationUtils.validateRequiredParameter(elementId, "Process definiton element id");
            ValidationUtils.validateRequiredParameter(attrName, "Attribute name");
            ValidationUtils.validateRequiredParameter(mapAttrName, "Attribute mapping name");
            if (!elementMap.keySet().contains(elementId)) {
                throw new SasDefinitionElementNotFoundException(elementId);
            }
            Element.ElementType elementType = ((FlowElementDefinition)elementMap.get(elementId)).getType();
            List<MappingAttributeMetadata> mappableAttributes = metaDataMap.get(elementType);
            if (mappableAttributes == null || mappableAttributes.size() == 0) {
                throw new SasDefintionElementNotAutoflowMappableException((FlowElementDefinition)elementMap.get(elementId), autoflowType, metaDataMap.keySet());
            }
            Set autoFlowMappingMeta = null;
            String validatedAttrName = null;
            for (MappingAttributeMetadata mappingAttributeMeta : mappableAttributes) {
                if (!mappingAttributeMeta.getAttrName().equalsIgnoreCase(attrName)) continue;
                validatedAttrName = mappingAttributeMeta.getAttrName();
                autoFlowMappingMeta = mappingAttributeMeta.getMapAttributes();
                break;
            }
            if (validatedAttrName == null || autoFlowMappingMeta == null) {
                throw new ResultException("Attribute " + attrName + " is not defined for element " + elementId);
            }
            AutoFlowMappingMetadata mappingData = null;
            String validatedMapAttrName = null;
            for (AutoFlowMappingMetadata autoflowMapping : autoFlowMappingMeta) {
                if (!autoflowMapping.getMapAttrName().equalsIgnoreCase(mapAttrName)) continue;
                validatedMapAttrName = autoflowMapping.getMapAttrName();
                mappingData = autoflowMapping;
                break;
            }
            if (validatedMapAttrName == null || mappingData == null) {
                throw new ResultException("Mapping attribute " + mapAttrName + " is not defined for attribute " + attrName);
            }
            FlowElementMapping fem = (FlowElementMapping)newMappings.get(elementId);
            if (fem == null) {
                fem = new FlowElementMapping(elementId, elementType);
            }
            fem.getAttributeMapping().add(new AttributeMapping(validatedAttrName, validatedMapAttrName, mappingData.getType()));
            newMappings.put(elementId, fem);
        }
        ArrayList<FlowElementMapping> arrayList = new ArrayList<FlowElementMapping>();
        for (String elementId : newMappings.keySet()) {
            arrayList.add((FlowElementMapping)newMappings.get(elementId));
        }
        return arrayList;
    }

    static {
        definitionMetadata = new HashMap<AutoFlowType, Map<Element.ElementType, List<MappingAttributeMetadata>>>();
    }
}

