/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.definition.mapping;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.workflow.definition.SasProcessDefinitionInfosResult;
import com.sas.lsaf.macro.workflow.definition.mapping.SasDefElementMappingsResult;
import com.sas.lsaf.macro.workflow.definition.mapping.SasDefinitionElementNotFoundException;
import com.sas.lsaf.macro.workflow.definition.mapping.SasDefintionNotAutoflowEnabledException;
import com.sas.lsaf.macro.workflow.definition.mapping.SasFlowElementMappings;
import com.sas.lsaf.macro.workflow.definition.mapping.SasProcessDefinitionAutoflowMetadataHelper;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.FlowElementMapping;
import com.sas.lsaf.workflow.processdefinition.FlowElementDefinition;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMapping;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessDefinitionMappingService {
    private static Log LOG = LogFactory.getLog(ProcessDefinitionMappingService.class);
    private static ProcessDefinitionMappingService FOR_COVERAGE = new ProcessDefinitionMappingService();

    private ProcessDefinitionMappingService() {
    }

    private static ProcessDefinitionService doGetService() {
        return ServiceManagerFactory.getApiProcessDefinitionService();
    }

    public static void getProcessDefinitionsMappedForAutoFlow(String contextTypeId, String autoFlowType, String activeOnly, SasProcessDefinitionInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting process definitions mapped for metadata for context " + contextTypeId));
        }
        try {
            boolean active = ValidationUtils.validateBinaryFlagDefaultFalse(activeOnly, "Active only");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            String cti = ValidationUtils.valueIsMissing((Serializable)((Object)contextTypeId)) ? null : contextTypeId;
            List def = ProcessDefinitionMappingService.doGetService().getProcessDefinitionsMappedForAutoFlow(cti, type, active);
            result.setProcessDefinitions(def);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean processDefinitionMappingIsComplete(String processDefKey, String autoFlowType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping is completed for process definition " + processDefKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionMapping mapping = ProcessDefinitionMappingService.doGetService().getProcessDefinitionMappingByType(type, processDefKey);
            result.init(0, "Success.");
            return mapping.isMappingComplete();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean processDefinitionAutoflowEnabled(String processDefKey, String autoFlowType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Autoflow is enabled for process definition " + processDefKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionMapping mapping = ProcessDefinitionMappingService.doGetService().getProcessDefinitionMappingByType(type, processDefKey);
            result.init(0, "Success.");
            return mapping.isEnableAutoFlowMapping();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void setProcessDefinitionAutoflowEnabled(String processDefKey, String autoFlowType, String enableAutoFlow, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting autoflow enabled for process definition " + processDefKey + " to " + enableAutoFlow));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            boolean enable = ValidationUtils.validateBinaryFlagDefaultTrue(enableAutoFlow, "Enable autoflow");
            ProcessDefinitionService srv = ProcessDefinitionMappingService.doGetService();
            ProcessDefinitionMapping mapping = srv.getProcessDefinitionMappingByType(type, processDefKey);
            mapping.setEnableAutoFlowMapping(enable);
            srv.updateProcessDefinitionMapping(mapping);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProcessDefinitionMappings(String processDefKey, String elementId, String autoFlowType, SasDefElementMappingsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting mappings for process definition " + processDefKey + " elementId: " + elementId));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionMapping mapping = ProcessDefinitionMappingService.doGetService().getProcessDefinitionMappingByType(type, processDefKey);
            if (!mapping.isEnableAutoFlowMapping()) {
                throw new SasDefintionNotAutoflowEnabledException(type);
            }
            result.setMappings(SasProcessDefinitionAutoflowMetadataHelper.toSasElementsFlowMappings(elementId, mapping));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void clearAllProcessDefinitionMappings(String processDefKey, String autoFlowType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clear all the mappings for process definition " + processDefKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionService srv = ProcessDefinitionMappingService.doGetService();
            ProcessDefinitionMapping mapping = srv.getProcessDefinitionMappingByType(type, processDefKey);
            if (!mapping.isEnableAutoFlowMapping()) {
                throw new SasDefintionNotAutoflowEnabledException(type);
            }
            mapping.getElementMapping().clear();
            srv.updateProcessDefinitionMapping(mapping);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void clearProcessDefinitionElementMappings(String processDefKey, String elementId, String autoFlowType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clear the mappings for process definition " + processDefKey + " element " + elementId));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            ValidationUtils.validateRequiredParameter(elementId, "Process definiton element id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionService srv = ProcessDefinitionMappingService.doGetService();
            ProcessDefinitionInfo pdi = srv.getProcessDefinitionByKey(processDefKey);
            Set elements = srv.getProcessDefinitionElements(pdi.getId());
            boolean foundElement = false;
            for (FlowElementDefinition def : elements) {
                if (!def.getElementId().equals(elementId)) continue;
                foundElement = true;
                break;
            }
            if (!foundElement) {
                throw new SasDefinitionElementNotFoundException(elementId);
            }
            ProcessDefinitionMapping mapping = srv.getProcessDefinitionMappingByType(type, processDefKey);
            if (!mapping.isEnableAutoFlowMapping()) {
                throw new SasDefintionNotAutoflowEnabledException(type);
            }
            ArrayList<FlowElementMapping> elementMappings = new ArrayList<FlowElementMapping>();
            for (FlowElementMapping eMap : mapping.getElementMapping()) {
                if (eMap.getElementId().equals(elementId)) continue;
                elementMappings.add(eMap);
            }
            mapping.setElementMapping(elementMappings);
            srv.updateProcessDefinitionMapping(mapping);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateProcessDefinitionMappings(String processDefKey, String autoFlowType, SasFlowElementMappings mappingData, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating mappings for process definition " + processDefKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ProcessDefinitionService srv = ProcessDefinitionMappingService.doGetService();
            ProcessDefinitionMapping mapping = srv.getProcessDefinitionMappingByType(type, processDefKey);
            if (!mapping.isEnableAutoFlowMapping()) {
                throw new SasDefintionNotAutoflowEnabledException(type);
            }
            mapping.setElementMapping(SasProcessDefinitionAutoflowMetadataHelper.toProcessDefinitionElementMappings(processDefKey, type, mappingData));
            srv.updateProcessDefinitionMapping(mapping);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

