/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.definition;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasStrings;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.workflow.definition.SasProcessDefinitionContextsResult;
import com.sas.lsaf.macro.workflow.definition.SasProcessDefinitionElementsResult;
import com.sas.lsaf.macro.workflow.definition.SasProcessDefinitionInfosResult;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessDefinitionService {
    private static Log LOG = LogFactory.getLog(ProcessDefinitionService.class);
    private static ProcessDefinitionService FOR_COVERAGE = new ProcessDefinitionService();

    private ProcessDefinitionService() {
    }

    public static com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService doGetService() {
        return ServiceManagerFactory.getApiProcessDefinitionService();
    }

    public static ProcessDefinitionInfo doGetProcessDefByKey(String processDefinitionKey) throws ProcessDefinitionNotFoundException {
        ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
        return ProcessDefinitionService.doGetService().getProcessDefinitionByKey(processDefinitionKey);
    }

    public static void getAllProcessDefinitions(SasProcessDefinitionInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting all process definitions");
        }
        try {
            List defs = ProcessDefinitionService.doGetService().getAllProcessDefinitions();
            result.setProcessDefinitions(defs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProcessDefinitionsByType(String contextType, SasProcessDefinitionInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting process definitions for context type " + contextType));
        }
        try {
            ValidationUtils.assertRequiredType(contextType);
            List defs = ProcessDefinitionService.doGetService().getProcessDefinitionsByContextType(contextType);
            result.setProcessDefinitions(defs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isProcessDefinitionDeployedForContextType(String processDefinitionKey, String contextTypeId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is process definition " + processDefinitionKey + " deployed for context type " + contextTypeId));
        }
        try {
            ValidationUtils.assertRequiredType(contextTypeId);
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            List defs = ProcessDefinitionService.doGetService().getProcessDefinitionsByContextType(contextTypeId);
            boolean found = false;
            for (ProcessDefinitionInfo pdi : defs) {
                if (!pdi.getProcessDefinitionKey().equals(processDefinitionKey)) continue;
                found = true;
                break;
            }
            result.init(0, "Success.");
            return found;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static String deployProcessDefinitionFromRepository(String path, String version, SasStrings contextTypeIds, String comment, String activate, String overwrite, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deploying process definition " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            boolean activateIt = ValidationUtils.validateBinaryFlagDefaultTrue(activate, "activate Process definition");
            boolean overwriteIt = ValidationUtils.validateBinaryFlagDefaultFalse(overwrite, "Overwrite process definition");
            HashSet<String> contextTypes = new HashSet<String>(contextTypeIds.getList());
            ProcessDefinitionInfo pdInfo = ProcessDefinitionService.doGetService().deployProcessDefinitionFromRepository(path, version, contextTypes, comment, activateIt, overwriteIt);
            result.init(0, "Success.");
            return pdInfo.getProcessDefinitionKey();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void activateProcessDefinition(String processDefinitionKey, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating process definition " + processDefinitionKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            ProcessDefinitionService.doGetService().activateProcessDefinition(processDefinitionKey);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void suspendProcessDefinition(String processDefinitionKey, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suspending process definition " + processDefinitionKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            ProcessDefinitionService.doGetService().suspendProcessDefinition(processDefinitionKey);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getProcessDefinitionStatus(String processDefinitionKey, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting status for process definition " + processDefinitionKey));
        }
        try {
            ProcessDefinitionInfo pdi = ProcessDefinitionService.doGetProcessDefByKey(processDefinitionKey);
            result.init(0, "Success.");
            return pdi.getStatus().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getProcessDefinitionContexts(String processDefinitionKey, SasProcessDefinitionContextsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting contexts for process definition " + processDefinitionKey));
        }
        try {
            ProcessDefinitionInfo pdi = ProcessDefinitionService.doGetProcessDefByKey(processDefinitionKey);
            result.setProcessDefinition(pdi);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProcessDefinitionElements(String processDefinitionKey, SasProcessDefinitionElementsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the elements for process definition " + processDefinitionKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            com.sas.lsaf.workflow.processdefinition.ProcessDefinitionService srv = ProcessDefinitionService.doGetService();
            ProcessDefinitionInfo pdi = srv.getProcessDefinitionByKey(processDefinitionKey);
            Set elements = srv.getProcessDefinitionElements(pdi.getId());
            result.setElements(elements);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

