/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.autoflow;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.autoflow.AutoFlowService;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AutoflowService {
    private static Log LOG = LogFactory.getLog(AutoflowService.class);
    private static AutoflowService FOR_COVERAGE = new AutoflowService();

    private AutoflowService() {
    }

    private static AutoFlowService doGetService() {
        return ServiceManagerFactory.getApiAutoFlowService();
    }

    public static String createAutoFlowProcess(String contextId, String processDefinitionKey, String autoFlowType, String namePrefix, String sourceId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating autoflow process using " + processDefinitionKey));
        }
        try {
            ValidationUtils.validateRequiredParameter(contextId, "Context id");
            ValidationUtils.validateRequiredParameter(processDefinitionKey, "Process definition id");
            AutoFlowType type = ValidationUtils.validateAutoFlowType(autoFlowType, true);
            ValidationUtils.validateRequiredParameter(namePrefix, "Prefix");
            ValidationUtils.validateRequiredParameter(sourceId, "Source id");
            ProcessFlowDescriptor pf = AutoflowService.doGetService().createAutoFlow(contextId, processDefinitionKey, type, namePrefix, sourceId);
            result.init(0, "Success.");
            return pf.getName();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }
}

