/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.workflow.processflow.DataProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SasDataPropertyResult
extends Result {
    private List<DataProperty> dataProps = new ArrayList<DataProperty>();

    public void setDataProperties(Set<DataProperty> data) {
        this.dataProps.addAll(data);
    }

    public List<DataProperty> getDataProperties() {
        return this.dataProps;
    }

    public int getSize() {
        return this.dataProps.size();
    }

    public DataProperty getDataProperty(double index) {
        return this.dataProps.get((int)index);
    }

    public String getId(double index) {
        return this.getDataProperty(index).getId();
    }

    public String getName(double index) {
        return this.getDataProperty(index).getName();
    }

    public String getType(double index) {
        return this.getDataProperty(index).getType().name();
    }

    public String getValue(double index) {
        Serializable ser = this.getDataProperty(index).getValue();
        if (ser == null) {
            return "";
        }
        if (ser instanceof Date) {
            return SasUtils.toSasDatetimeFormat((Date)ser);
        }
        if (ser instanceof Boolean) {
            return SasUtils.toSasString((Boolean)ser);
        }
        return SasUtils.toSasString(ser.toString());
    }

    public String getDateValueSasFormat(double index) {
        DataProperty value = this.getDataProperty(index);
        if (value instanceof Date) {
            return SasUtils.toSasDatetimeFormat((Date)value);
        }
        return "";
    }

    public String getEnumValues(double index) {
        Map values = this.getDataProperty(index).getValues();
        if (values == null) {
            return "";
        }
        return SasUtils.toSasCommaDelimitedString(values.entrySet());
    }
}

