/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow;

import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.macro.common.SasObjectProperties;
import com.sas.lsaf.macro.common.SasObjectProperty;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowElementPrincipal;
import com.sas.lsaf.macro.workflow.setup.SasProcessFlowElementsParametersResult;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.processflow.setup.JobTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.NotificationTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.TaskSetup;
import com.sas.lsaf.workflow.processflow.setup.UserTaskSetup;
import com.sas.lsaf.workflow.task.CompletedJobTask;
import com.sas.lsaf.workflow.task.CompletedNotificationTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ProcessFlowElementHelper {
    public static final String TYPE_JOB_GENERIC = "JOB";
    public static final String TYPE_NOTIFICATIONTASK = "SYSTEM_NOTIFICATION";
    public static final String TYPE_USERTASK = "USER_TASK";
    public static final List<String> VALID_JOBELEMENT_TYPES = Arrays.asList(Element.ElementType.SYSTEM_JOB_EXEC.name(), Element.ElementType.SYSTEM_JOB_EXEC_NO_WAIT.name());

    private static List<SasProcessFlowElementPrincipal> doGetSasPfPrincipals(String elementId, Set<Principal> principals) {
        ArrayList<SasProcessFlowElementPrincipal> sasElementPrincipals = new ArrayList<SasProcessFlowElementPrincipal>();
        if (principals != null) {
            for (Principal p : principals) {
                sasElementPrincipals.add(new SasProcessFlowElementPrincipal(elementId, p));
            }
        }
        return sasElementPrincipals;
    }

    private static List<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue> doGetSasPfParameters(String elementId, String jobPath, String jobVersion, List<ParameterValue> parameters) {
        ArrayList<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue> sasPfParameters = new ArrayList<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue>();
        for (ParameterValue p : parameters) {
            sasPfParameters.add(new SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue(elementId, jobPath, jobVersion, p));
        }
        return sasPfParameters;
    }

    public static List<String> getValidElementTypes(String elementType) {
        if (elementType.equals(TYPE_JOB_GENERIC)) {
            return VALID_JOBELEMENT_TYPES;
        }
        ArrayList<String> validTypes = new ArrayList<String>();
        validTypes.add(elementType);
        return validTypes;
    }

    public static List<SasProcessFlowElementPrincipal> toSasPrincipalsFromElements(List<? extends Object> elements) {
        ArrayList<SasProcessFlowElementPrincipal> sasElementPrincipals = new ArrayList<SasProcessFlowElementPrincipal>();
        for (Object object : elements) {
            if (object instanceof CompletedNotificationTask) {
                CompletedNotificationTask cnt = (CompletedNotificationTask)object;
                sasElementPrincipals.addAll(ProcessFlowElementHelper.doGetSasPfPrincipals(cnt.getElementId(), cnt.getRecipients()));
                continue;
            }
            if (object instanceof UserTaskSetup) {
                UserTaskSetup uts = (UserTaskSetup)object;
                sasElementPrincipals.addAll(ProcessFlowElementHelper.doGetSasPfPrincipals(uts.getElementId(), uts.getCandidates()));
                continue;
            }
            if (!(object instanceof NotificationTaskSetup)) continue;
            NotificationTaskSetup nts = (NotificationTaskSetup)object;
            sasElementPrincipals.addAll(ProcessFlowElementHelper.doGetSasPfPrincipals(nts.getElementId(), nts.getRecipients()));
        }
        return sasElementPrincipals;
    }

    public static List<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue> toSasPfParameterValues(List<? extends Object> elements) {
        ArrayList<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue> sasPfParameters = new ArrayList<SasProcessFlowElementsParametersResult.SasProcessFlowParameterValue>();
        for (Object object : elements) {
            if (object instanceof CompletedJobTask) {
                CompletedJobTask cjt = (CompletedJobTask)object;
                sasPfParameters.addAll(ProcessFlowElementHelper.doGetSasPfParameters(cjt.getElementId(), cjt.getJobPath(), cjt.getJobVersion(), cjt.getParameterValues()));
                continue;
            }
            if (!(object instanceof JobTaskSetup)) continue;
            JobTaskSetup jts = (JobTaskSetup)object;
            sasPfParameters.addAll(ProcessFlowElementHelper.doGetSasPfParameters(jts.getElementId(), jts.getJobPath(), jts.getJobVersion(), jts.getParameterValues()));
        }
        return sasPfParameters;
    }

    public static List<SasObjectProperty> toSasObjectPropertyFromSetup(String elementType, TaskSetup element) {
        String elementId = element.getElementId();
        SasObjectProperties spfProps = new SasObjectProperties();
        String stringPropType = AttributeDefinition.AttributeType.STRING.name();
        spfProps.addReadonlyRequiredProperty(elementId, "elementType", stringPropType, (Serializable)element.getType());
        spfProps.addReadonlyRequiredProperty(elementId, "id", stringPropType, (Serializable)((Object)element.getElementId()));
        spfProps.addEditableRequiredProperty(elementId, "name", stringPropType, (Serializable)((Object)element.getName()));
        spfProps.addEditableProperty(elementId, "description", stringPropType, (Serializable)((Object)element.getDescription()));
        switch (elementType) {
            case "JOB": {
                JobTaskSetup jobDef = (JobTaskSetup)element;
                spfProps.addEditableProperty(elementId, "jobPath", stringPropType, (Serializable)((Object)jobDef.getJobPath()));
                spfProps.addEditableProperty(elementId, "jobVersion", stringPropType, (Serializable)((Object)jobDef.getJobVersion()));
                break;
            }
            case "USER_TASK": {
                UserTaskSetup userDef = (UserTaskSetup)element;
                String taskPriority = userDef.getPriority() == null ? null : userDef.getPriority().name();
                String taskComplexity = userDef.getComplexity() == null ? null : userDef.getComplexity().name();
                spfProps.addEditableProperty(elementId, "dueDate", AttributeDefinition.AttributeType.DATE.name(), userDef.getDueDate());
                spfProps.addEditableProperty(elementId, "priority", stringPropType, (Serializable)((Object)taskPriority));
                spfProps.addEditableProperty(elementId, "complexity", stringPropType, (Serializable)((Object)taskComplexity));
                spfProps.addEditableProperty(elementId, "assigneeID", stringPropType, (Serializable)((Object)userDef.getAssignee()));
                break;
            }
            case "SYSTEM_NOTIFICATION": {
                NotificationTaskSetup notiDef = (NotificationTaskSetup)element;
                String priority = notiDef.getPriority() == null ? null : notiDef.getPriority().name();
                spfProps.addEditableRequiredProperty(elementId, "priority", stringPropType, (Serializable)((Object)priority));
                spfProps.addEditableRequiredProperty(elementId, "subject", stringPropType, (Serializable)((Object)notiDef.getSubject()));
                spfProps.addEditableProperty(elementId, "message", stringPropType, (Serializable)((Object)notiDef.getMessage()));
                break;
            }
        }
        PropertyUtils.addObjectExtAttrsToProperties(spfProps, element.getAttributes(), elementId, "sas:task");
        return spfProps.getProperties();
    }
}

