/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.user;

import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasObjectProperties;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasObjectPropertiesResult;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.StringUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.user.SasUserAuthenticationProvidersResult;
import com.sas.lsaf.macro.security.user.SasUserLicenseTypesResult;
import com.sas.lsaf.macro.security.user.SasUsersResult;
import com.sas.lsaf.security.user.AccountInfo;
import com.sas.lsaf.security.user.User;
import com.sas.lsaf.security.user.UserCreateInfo;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UserService {
    private static Log LOG = LogFactory.getLog(UserService.class);
    public static final String DO_NOT_UPDATE = "_lsaf_updateuser_donotupdate_";
    private static UserService FOR_COVERAGE = new UserService();

    private UserService() {
    }

    private static com.sas.lsaf.security.user.UserService doGetService() {
        return ServiceManagerFactory.getApiUserService();
    }

    public static void getProperties(String userId, SasObjectPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting properties for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            User user = UserService.doGetService().getUserByUserId(userId);
            SasObjectProperties props = new SasObjectProperties();
            String typeString = AttributeDefinition.AttributeType.STRING.name();
            String typeDate = AttributeDefinition.AttributeType.DATE.name();
            String typeBool = AttributeDefinition.AttributeType.BOOLEAN.name();
            props.addReadonlyRequiredProperty(null, "userId", typeString, (Serializable)((Object)user.getUserId()));
            props.addEditableProperty(null, "displayName", typeString, (Serializable)((Object)user.getDisplayName()));
            props.addEditableProperty(null, "firstName", typeString, (Serializable)((Object)user.getFirstName()));
            props.addEditableProperty(null, "lastName", typeString, (Serializable)((Object)user.getLastName()));
            props.addEditableProperty(null, "department", typeString, (Serializable)((Object)user.getDepartment()));
            props.addEditableProperty(null, "phone", typeString, (Serializable)((Object)user.getPhone()));
            props.addEditableRequiredProperty(null, "email", typeString, (Serializable)((Object)user.getEmail()));
            props.addReadonlyProperty(null, "isLocked", typeBool, (Serializable)((Object)SasUtils.toSasString(user.getLockedInfo().isLocked())));
            props.addReadonlyProperty(null, "lockedBy", typeString, (Serializable)((Object)user.getLockedInfo().getLockedBy()));
            props.addReadonlyProperty(null, "lockedDate", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getLockedInfo().getLockedDate())));
            props.addEditableRequiredProperty(null, "accountType", typeString, (Serializable)user.getAccountInfo().getAccountType());
            props.addEditableRequiredProperty(null, "licenseType", typeString, (Serializable)((Object)user.getAccountInfo().getLicenseTypeId()));
            props.addReadonlyProperty(null, "isActive", typeBool, (Serializable)((Object)SasUtils.toSasString(user.getAccountInfo().isActive())));
            props.addReadonlyProperty(null, "activationDate", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getAccountInfo().getActivationDate())));
            props.addReadonlyProperty(null, "deactivationDate", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getAccountInfo().getDeactivationDate())));
            props.addReadonlyProperty(null, "externalAuthenticator", typeString, (Serializable)((Object)user.getAccountInfo().getAuthenticator()));
            props.addReadonlyProperty(null, "externalAuthenticatorUserName", typeString, (Serializable)((Object)user.getAccountInfo().getAuthenticatorUsername()));
            props.addReadonlyProperty(null, "singleSignonId", typeString, (Serializable)((Object)user.getAccountInfo().getSingleSignOnId()));
            props.addReadonlyProperty(null, "lastLoggedIn", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getLoginInfo().getLastLogin())));
            props.addReadonlyProperty(null, "passwordCreatedDate", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getPasswordInfo().getCreated())));
            props.addReadonlyProperty(null, "passwordIsExpired", typeBool, (Serializable)((Object)SasUtils.toSasString(user.getPasswordInfo().isExpired())));
            props.addReadonlyProperty(null, "passwordExpirationDate", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getPasswordInfo().getExpiration())));
            props.addReadonlyProperty(null, "passwordExpirationDate_SASFmt", typeDate, (Serializable)((Object)SasUtils.toSasDatetimeFormat(user.getPasswordInfo().getExpiration())));
            props.addReadonlyRequiredProperty(null, "created", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getCreated())));
            props.addReadonlyRequiredProperty(null, "createdBy", typeString, (Serializable)((Object)user.getCreatedBy()));
            props.addReadonlyRequiredProperty(null, "lastModified", typeDate, (Serializable)((Object)SasUtils.toSasString(user.getLastModified())));
            props.addReadonlyRequiredProperty(null, "lastModifiedBy", typeString, (Serializable)((Object)user.getLastModifiedBy()));
            PropertyUtils.addObjectExtAttrsToProperties(props, user.getAttributes(), null, user.getTypeId());
            result.setProperties(props);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateProperties(String userId, SasProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating properties for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredSasProperties(properties);
            User user = UserService.doGetService().getUserByUserId(userId);
            PropertyUtils.updateIdentifiablePropertiesByType((AbstractIdentifiable)user, user.getAttributes(), properties);
            UserService.doGetService().updateUser(user);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAllUsers(SasUsersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting all users");
        }
        try {
            Set us = UserService.doGetService().getAllUsers();
            result.setUsers(us);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void create(String userId, String displayName, String email, String accountType, String password, String firstName, String lastName, String department, String phone, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.validateRequiredParameter(displayName, "Display name");
            ValidationUtils.validateRequiredParameter(email, "Email");
            ValidationUtils.assertRequiredPassword(password);
            AccountInfo.AccountType acctType = (AccountInfo.AccountType)ValidationUtils.validateUpcasedEnum(accountType, "Account type", AccountInfo.AccountType.class);
            UserCreateInfo userInfo = new UserCreateInfo();
            userInfo.setAccountType(acctType);
            userInfo.setDepartment(StringUtils.trim(department));
            userInfo.setDisplayName(StringUtils.trim(displayName));
            userInfo.setEmail(StringUtils.trim(email));
            userInfo.setFirstName(StringUtils.trim(firstName));
            userInfo.setLastName(StringUtils.trim(lastName));
            userInfo.setPassword(StringUtils.trim(password));
            userInfo.setPhone(StringUtils.trim(phone));
            userInfo.setUserId(StringUtils.trim(userId));
            UserService.doGetService().createUser(userInfo);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean exists(String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            boolean exists = UserService.doGetService().userExists(userId);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    public static void delete(String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            UserService.doGetService().deleteUser(userId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void resetPassword(String userId, String newPassword, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resetting password for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredPassword(newPassword);
            UserService.doGetService().resetPassword(userId, StringUtils.trim(newPassword));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String encryptPassword(String textPassword, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating encrypted password");
        }
        try {
            byte[] pw = ValidationUtils.assertRequiredPassword(textPassword);
            String encryptedPassword = UserService.doGetService().encryptPassword(pw);
            result.init(0, "Success.");
            return encryptedPassword;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return null;
        }
    }

    public static void lockUser(String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Locking user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            UserService.doGetService().lockUser(userId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void unlockUser(String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unlocking user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            UserService.doGetService().unlockUser(userId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isLocked(String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if user is locked: " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            result.init(0, "Success.");
            boolean isLocked = UserService.doGetService().getUserByUserId(userId).getLockedInfo().isLocked();
            return isLocked;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getLicenceTypes(SasUserLicenseTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting license types");
        }
        try {
            Set lTypes = UserService.doGetService().getLicenseTypes();
            result.setLicenseTypes(lTypes);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAuthenticationProviders(SasUserAuthenticationProvidersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting authentication providers");
        }
        try {
            List apis = UserService.doGetService().getAuthenticationProviderInfos();
            result.setAuthenticationProviders(apis);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setDefaultAuthenticator(String userId, String password, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting default authenticator for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredPassword(password);
            UserService.doGetService().setDefaultAuthenticatorByUserId(userId, password);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setExternalAuthenticator(String userId, String authenticator, String authenticatorUsername, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting default authenticator for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.validateRequiredParameter(authenticator, "Authenticator");
            UserService.doGetService().setExternalAuthenticatorByUserId(userId, authenticator, authenticatorUsername);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

