/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.user;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.security.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasUsersResult
extends Result {
    public static final String ACCOUNT_TYPE_INTERACTIVE = "INTERACTIVE";
    public static final String ACCOUNT_TYPE_NON_INTERACTIVE = "NON_INTERACTIVE";
    private List<User> users = new ArrayList<User>();

    public void setUsers(Set<User> users) {
        this.users = new ArrayList<User>(users);
    }

    public List<User> getUsers() {
        return this.users;
    }

    public int getSize() {
        return this.users.size();
    }

    public String getUserId(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getUserId());
    }

    public String getFirstName(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getFirstName());
    }

    public String getLastName(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getLastName());
    }

    public String getDisplayName(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getDisplayName());
    }

    public String getDepartment(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getDepartment());
    }

    public String getEmail(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getEmail());
    }

    public String getPhone(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getPhone());
    }

    public String getAccountLicenseTypeId(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getAccountInfo().getLicenseTypeId());
    }

    public String getAccountType(double index) {
        switch (this.users.get((int)index).getAccountInfo().getAccountType()) {
            case INTERACTIVE: {
                return ACCOUNT_TYPE_INTERACTIVE;
            }
            case NON_INTERACTIVE: {
                return ACCOUNT_TYPE_NON_INTERACTIVE;
            }
        }
        throw new RuntimeException("Unmapped account type " + String.valueOf(this.users.get((int)index).getAccountInfo().getAccountType()));
    }

    public int isAccountActive(double index) {
        return this.users.get((int)index).getAccountInfo().isActive() ? 1 : 0;
    }

    public String getAccountActivationDate(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getAccountInfo().getActivationDate());
    }

    public String getAccountActivationDateSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getAccountInfo().getActivationDate());
    }

    public String getAccountDeactivationDate(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getAccountInfo().getDeactivationDate());
    }

    public String getAccountDeactivationDateSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getAccountInfo().getDeactivationDate());
    }

    public int isAccountLocked(double index) {
        return this.users.get((int)index).getLockedInfo().isLocked() ? 1 : 0;
    }

    public String getAccountLockedBy(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getLockedInfo().getLockedBy());
    }

    public String getAccountLockedDate(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getLockedInfo().getLockedDate());
    }

    public String getAccountLockedDateSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getLockedInfo().getLockedDate());
    }

    public long getLoginAttempts(double index) {
        return this.users.get((int)index).getLoginInfo().getLoginAttempts();
    }

    public String getLastLogin(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getLoginInfo().getLastLogin());
    }

    public String getLastLoginSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getLoginInfo().getLastLogin());
    }

    public String getPasswordCreated(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getPasswordInfo().getCreated());
    }

    public String getPasswordCreatedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getPasswordInfo().getCreated());
    }

    public String getPasswordExpiration(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getPasswordInfo().getExpiration());
    }

    public String getPasswordExpirationSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getPasswordInfo().getExpiration());
    }

    public int isPasswordExpired(double index) {
        return this.users.get((int)index).getPasswordInfo().isExpired() ? 1 : 0;
    }

    public String getCreatedBy(double index) {
        return this.users.get((int)index).getCreatedBy();
    }

    public String getCreated(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getCreated());
    }

    public String getCreatedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getCreated());
    }

    public String getLastModifiedBy(double index) {
        return this.users.get((int)index).getLastModifiedBy();
    }

    public String getLastModified(double index) {
        return SasUtils.toSasString(this.users.get((int)index).getLastModified());
    }

    public String getLastModifiedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.users.get((int)index).getLastModified());
    }
}

