/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.role;

import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;

public class SasRole {
    private String path;
    private String roleName;
    private String roleContext;
    private boolean isInherited = false;

    public SasRole(String path, String role, String roleContext) {
        this.path = path;
        this.roleName = role;
        this.roleContext = roleContext;
        this.isInherited = !ValidationUtils.valueIsMissing((Serializable)((Object)this.roleContext)) && !this.roleContext.equals(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRoleContext() {
        return this.roleContext;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public String getDefinedContext() {
        return this.isInherited() ? this.roleContext : this.path;
    }

    public String getAssignedContext() {
        return this.path;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SasRole [");
        buf.append("Path: " + this.getPath());
        buf.append(", Name: " + this.getRoleName());
        buf.append(", RoleContext: " + this.getRoleContext());
        buf.append(", definedContext: " + this.getDefinedContext());
        buf.append(", assignedContext: " + this.getAssignedContext());
        buf.append(", isInherited: " + this.isInherited());
        buf.append("]");
        return buf.toString();
    }
}

