/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.role;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.SasParameterInvalidException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.macro.security.SasPrincipalsResult;
import com.sas.lsaf.macro.security.privilege.SasPrivilegesResult;
import com.sas.lsaf.macro.security.role.SasRole;
import com.sas.lsaf.macro.security.role.SasRoleDescriptor;
import com.sas.lsaf.macro.security.role.SasRolesResult;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.privilege.ScopedPrivilege;
import com.sas.lsaf.security.role.Role;
import com.sas.lsaf.security.role.RoleDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RoleService {
    private static Log LOG = LogFactory.getLog(RoleService.class);
    private static RoleService FOR_COVERAGE = new RoleService();

    private RoleService() {
    }

    private static com.sas.lsaf.security.role.RoleService doGetService() {
        return ServiceManagerFactory.getApiRoleService();
    }

    private static void doValidateRoleParameters(String path, String roleName) {
        ValidationUtils.assertRequiredPath(path);
        ValidationUtils.validateRequiredParameter(roleName, "Role");
    }

    private static void doValidateRoleParameters(SasRole sasRole) {
        RoleService.doValidateRoleParameters(sasRole.getPath(), sasRole.getRoleName());
    }

    private static void doValidateInheritedRoleParameters(SasRole sasRole) {
        RoleService.doValidateRoleParameters(sasRole.getPath(), sasRole.getRoleName());
        ValidationUtils.validateRequiredParameter(sasRole.getRoleContext(), "Role context path");
    }

    private static ScopedPrivilege validateScopedPrivilege(String value) {
        ValidationUtils.validateRequiredParameter(value, "Privilege");
        Set ps = ServiceManagerFactory.getApiScopedPrivilegeService().getAvailablePrivileges();
        for (ScopedPrivilege p : ps) {
            if (!p.getId().equals(value.toUpperCase())) continue;
            return p;
        }
        throw new SasParameterInvalidException("Privilege", null);
    }

    private static RoleDescriptor doGetDefinedRoleDescriptor(String path, String roleName) throws Exception {
        String ci = RepositoryUtils.getRepositoryItemId(path);
        return RoleService.doGetService().getRoleDescriptorByName(ci, roleName);
    }

    private static RoleDescriptor doGetDefinedRoleDescriptor(SasRole sasRole) throws Exception {
        return RoleService.doGetDefinedRoleDescriptor(sasRole.getDefinedContext(), sasRole.getRoleName());
    }

    private static Role doGetRole(String path, String roleName) throws Exception {
        String ci = RepositoryUtils.getRepositoryItemId(path);
        return RoleService.doGetService().getRoleByName(ci, roleName);
    }

    private static Role doGetRoleBySasRole(SasRole sasRole) throws Exception {
        if (!sasRole.isInherited()) {
            return RoleService.doGetRole(sasRole.getDefinedContext(), sasRole.getRoleName());
        }
        String contextId = RepositoryUtils.getRepositoryItemId(sasRole.getAssignedContext());
        Set allRoles = RoleService.doGetService().getRolesByContext(contextId);
        for (Role r : allRoles) {
            if (!r.isInherited() || !sasRole.getRoleName().equals(r.getName()) || !sasRole.getDefinedContext().equals(RepositoryUtils.getPathFromItemIdentity(r.getDefinedContext()))) continue;
            return r;
        }
        throw new ResultException("Inherited role " + sasRole.getRoleName() + " defined at " + sasRole.getDefinedContext() + " was not found.");
    }

    private static String doGetInheritedRoleId(SasRole sasRole) throws Exception {
        RoleService.doValidateInheritedRoleParameters(sasRole);
        String definedContextId = RepositoryUtils.getRepositoryItemId(sasRole.getDefinedContext());
        com.sas.lsaf.security.role.RoleService srv = RoleService.doGetService();
        RoleDescriptor definedRoleDesc = srv.getRoleDescriptorByName(definedContextId, sasRole.getRoleName());
        String definedRoleId = definedRoleDesc.getId();
        Set inheritedRoles = srv.getInheritedRoleDescriptorsByRole(definedRoleId);
        String assignedContextId = RepositoryUtils.getRepositoryItemId(sasRole.getAssignedContext());
        for (RoleDescriptor ir : inheritedRoles) {
            if (!assignedContextId.equals(ir.getAssignedContext().getId())) continue;
            return ir.getId();
        }
        return "invalidInheritedRoleId";
    }

    private static List<SasRoleDescriptor> toSasRoleDescriptors(Set<RoleDescriptor> roles) throws Exception {
        ArrayList<SasRoleDescriptor> sasRoleDescriptors = new ArrayList<SasRoleDescriptor>();
        for (RoleDescriptor r : roles) {
            SasRoleDescriptor srd = new SasRoleDescriptor(r.getName(), r.getDescription());
            srd.setAssignedPath(RepositoryUtils.getPathFromItemIdentity(r.getAssignedContext()));
            srd.setDefinedPath(RepositoryUtils.getPathFromItemIdentity(r.getDefinedContext()));
            srd.setIsInherited(r.isInherited());
            sasRoleDescriptors.add(srd);
        }
        return sasRoleDescriptors;
    }

    public static void getRoles(String path, SasPrincipalDescriptor sasPrincipal, SasRolesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting roles for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            if (ValidationUtils.valueIsMissing((Serializable)((Object)sasPrincipal.getName()))) {
                Set roles = RoleService.doGetService().getRoleDescriptorsByContext(ci);
                result.setList(RoleService.toSasRoleDescriptors(roles));
            } else {
                Principal p = PrincipalUtils.getMemberAsPrincipal(sasPrincipal);
                Set roles = RoleService.doGetService().getRoleDescriptorsByContextAndPrincipal(ci, p);
                result.setList(RoleService.toSasRoleDescriptors(roles));
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getInheritedRolesByRole(String path, String roleName, SasRolesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting inherited roles for " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(path, roleName);
            Set roles = RoleService.doGetService().getInheritedRoleDescriptorsByRole(rd.getId());
            result.setList(RoleService.toSasRoleDescriptors(roles));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String create(String path, String roleName, String description, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating role " + roleName + " at " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Role r = RoleService.doGetService().createRole(ci, roleName, description, null, null);
            result.init(0, "Success.");
            return r.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void rename(String path, String roleName, String newName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming role " + roleName + " to" + newName + " at " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            ValidationUtils.validateRequiredParameter(newName, "New name");
            Role role = RoleService.doGetRole(path, roleName);
            role.setName(newName);
            RoleService.doGetService().updateRole(role);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateDescription(String path, String roleName, String newDescripiton, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating description for role " + roleName + " at " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            ValidationUtils.validateRequiredParameter(newDescripiton, "New description");
            Role role = RoleService.doGetRole(path, roleName);
            role.setDescription(newDescripiton);
            RoleService.doGetService().updateRole(role);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void delete(String path, String roleName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting role " + roleName + " from " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(path, roleName);
            RoleService.doGetService().deleteRole(rd.getId());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRolesByPrivilege(String path, String privilegeName, SasRolesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting roles wtih " + privilegeName + " in " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Set roles = RoleService.doGetService().getRoleDescriptorsByContextAndPrivilege(ci, privilegeName);
            result.setList(RoleService.toSasRoleDescriptors(roles));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void addPrivilege(String path, String roleName, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding privilege " + privilegeName + " to role " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            ScopedPrivilege sp = RoleService.validateScopedPrivilege(privilegeName);
            Role r = RoleService.doGetRole(path, roleName);
            boolean added = r.getPrivileges().add(sp);
            if (added) {
                RoleService.doGetService().updateRole(r);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removePrivilege(String path, String roleName, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing privilege " + privilegeName + " from role " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            ScopedPrivilege sp = RoleService.validateScopedPrivilege(privilegeName);
            Role r = RoleService.doGetRole(path, roleName);
            boolean removed = r.getPrivileges().remove(sp);
            if (removed) {
                RoleService.doGetService().updateRole(r);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getPrivileges(String path, String roleName, SasPrivilegesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting privileges on role " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(path, roleName);
            result.setPrivileges("SCOPED", rd.getPrivileges());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean hasPrivilege(String path, String roleName, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking privilege " + privilegeName + " on role " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            ScopedPrivilege sp = RoleService.validateScopedPrivilege(privilegeName);
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(path, roleName);
            result.init(0, "Success.");
            return rd.getPrivileges().contains(sp);
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean roleExistsAtContext(SasRole sasRole, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking if role " + sasRole.toString() + " exists at context"));
        }
        try {
            RoleService.doValidateRoleParameters(sasRole);
            String ci = RepositoryUtils.getRepositoryItemId(sasRole.getPath());
            boolean exists = false;
            if (sasRole.isInherited()) {
                RoleDescriptor roleDefinedAtContextPath = RoleService.doGetDefinedRoleDescriptor(sasRole);
                exists = RoleService.doGetService().inheritedRoleExists(ci, roleDefinedAtContextPath.getId());
            } else {
                exists = RoleService.doGetService().roleExists(ci, sasRole.getRoleName());
            }
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getMembers(SasRole sasRole, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting members in role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateRoleParameters(sasRole);
            Role role = RoleService.doGetRoleBySasRole(sasRole);
            result.setPrincipals(role.getMembers());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void addMember(SasRole sasRole, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " to role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateRoleParameters(sasRole);
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            Role role = RoleService.doGetRoleBySasRole(sasRole);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean added = role.getMembers().add(p);
            if (added) {
                RoleService.doGetService().updateRole(role);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeMember(SasRole sasRole, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " from role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateRoleParameters(sasRole);
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            Role role = RoleService.doGetRoleBySasRole(sasRole);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean removed = role.getMembers().remove(p);
            if (removed) {
                RoleService.doGetService().updateRole(role);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean hasMember(SasRole sasRole, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " on role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateRoleParameters(sasRole);
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            Role role = RoleService.doGetRoleBySasRole(sasRole);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean hasMember = RoleService.doGetService().isPrincipalInRole(role.getId(), p);
            result.init(0, "Success.");
            return hasMember;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean hasPrivilegeAtContext(String path, String privilegeName, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking member" + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " has privilege " + privilegeName + " at context " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            ScopedPrivilege sp = RoleService.validateScopedPrivilege(privilegeName);
            String spId = ValidationUtils.valueIsMissing((Serializable)sp) ? null : sp.getId();
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean hasPriv = RoleService.doGetService().hasPrivilege(ci, spId, p);
            result.init(0, "Success.");
            return hasPriv;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void addInheritedRole(SasRole sasRole, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Assigning role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateInheritedRoleParameters(sasRole);
            String targetContextId = RepositoryUtils.getRepositoryItemId(sasRole.getAssignedContext());
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(sasRole);
            RoleService.doGetService().addInheritedRole(targetContextId, rd.getId(), null);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeInheritedRole(SasRole sasRole, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unassigning role " + sasRole.toString()));
        }
        try {
            String id = RoleService.doGetInheritedRoleId(sasRole);
            RoleService.doGetService().deleteRole(id);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean exists(String path, String roleName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of role " + roleName + " in " + path));
        }
        try {
            RoleService.doValidateRoleParameters(path, roleName);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            boolean exists = RoleService.doGetService().roleExists(ci, roleName);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean inheritedRoleExists(SasRole sasRole, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking if role " + sasRole.toString()));
        }
        try {
            RoleService.doValidateInheritedRoleParameters(sasRole);
            String targetContextId = RepositoryUtils.getRepositoryItemId(sasRole.getAssignedContext());
            RoleDescriptor rd = RoleService.doGetDefinedRoleDescriptor(sasRole.getDefinedContext(), sasRole.getRoleName());
            boolean exists = RoleService.doGetService().inheritedRoleExists(targetContextId, rd.getId());
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }
}

