/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.privilege.scoped;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.privilege.SasPrivilegesResult;
import com.sas.lsaf.security.privilege.Privilege;
import com.sas.lsaf.security.privilege.ScopedPrivilege;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScopedPrivilegeService {
    public static final String PRIVILEGE_TYPE = "SCOPED";
    private static Set<ScopedPrivilege> privileges;
    private static Log LOG;
    private static ScopedPrivilegeService FOR_COVERAGE;

    private ScopedPrivilegeService() {
    }

    private static Set<ScopedPrivilege> doGetPrivileges() {
        ValidationUtils.validateHaveLsafSession();
        if (privileges == null) {
            privileges = ServiceManagerFactory.getAPIServiceManager().getScopedPrivilegeService().getAvailablePrivileges();
        }
        return privileges;
    }

    public static void getAvailablePrivileges(SasPrivilegesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting available context privileges");
        }
        try {
            Set<ScopedPrivilege> ps = ScopedPrivilegeService.doGetPrivileges();
            result.setPrivileges(PRIVILEGE_TYPE, ps);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isScopedPrivilege(String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is a valid scoped privilege: " + privilegeName));
        }
        try {
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            Set<ScopedPrivilege> ps = ScopedPrivilegeService.doGetPrivileges();
            boolean found = false;
            for (Privilege privilege : ps) {
                if (!privilege.getId().equalsIgnoreCase(privilegeName)) continue;
                found = true;
                break;
            }
            result.init(0, "Success.");
            return found;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    static {
        LOG = LogFactory.getLog(ScopedPrivilegeService.class);
        FOR_COVERAGE = new ScopedPrivilegeService();
    }
}

