/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.privilege.global;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.privilege.SasPrivilegesResult;
import com.sas.lsaf.macro.security.privilege.global.SasPrivilegedUsersResult;
import com.sas.lsaf.security.privilege.GlobalPrivilege;
import com.sas.lsaf.security.privilege.Privilege;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GlobalPrivilegeService {
    public static final String PRIVILEGE_TYPE = "GLOBAL";
    private static Set<GlobalPrivilege> privileges;
    private static Log LOG;
    private static GlobalPrivilegeService FOR_COVERAGE;

    private GlobalPrivilegeService() {
    }

    private static com.sas.lsaf.security.privilege.GlobalPrivilegeService doGetService() {
        return ServiceManagerFactory.getApiGlobalPrivilegeService();
    }

    private static Set<GlobalPrivilege> doGetPrivileges() {
        ValidationUtils.validateHaveLsafSession();
        if (privileges == null) {
            privileges = GlobalPrivilegeService.doGetService().getAvailablePrivileges();
        }
        return privileges;
    }

    private static GlobalPrivilege doGetGlobalPrivilege(String privilegeName) {
        ValidationUtils.assertRequiredPrivilege(privilegeName);
        Set<GlobalPrivilege> ps = GlobalPrivilegeService.doGetPrivileges();
        for (Privilege privilege : ps) {
            if (!privilege.getId().equalsIgnoreCase(privilegeName)) continue;
            return (GlobalPrivilege)privilege;
        }
        return null;
    }

    public static void getUsersWithGlobalPrivilege(String privilegeName, SasPrivilegedUsersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting users with global privilege: " + privilegeName));
        }
        try {
            GlobalPrivilege gp = GlobalPrivilegeService.doGetGlobalPrivilege(privilegeName);
            Set users = GlobalPrivilegeService.doGetService().getGrantees(privilegeName);
            result.setUsers(PRIVILEGE_TYPE, (Privilege)gp, users);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getGlobalPrivileges(SasPrivilegesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting global privileges");
        }
        try {
            Set<GlobalPrivilege> ps = GlobalPrivilegeService.doGetPrivileges();
            result.setPrivileges(PRIVILEGE_TYPE, ps);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isGlobalPrivilege(String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if value is valid global privilege: " + privilegeName));
        }
        try {
            result.init(0, "Success.");
            return GlobalPrivilegeService.doGetGlobalPrivilege(privilegeName) != null;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getGrantedPrivileges(String userId, SasPrivilegesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting global privileges for user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            Set ps = GlobalPrivilegeService.doGetService().getGrantedPrivileges(userId);
            result.setPrivileges(PRIVILEGE_TYPE, ps);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void addPrivilege(String userId, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding privilege " + privilegeName + " to user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            GlobalPrivilegeService.doGetService().grantPrivilege(userId, privilegeName);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean hasPrivilege(String userId, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking privilege " + privilegeName + " on user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            boolean hasPrivilege = GlobalPrivilegeService.doGetService().hasPrivilege(userId, privilegeName);
            result.init(0, "Success.");
            return hasPrivilege;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void removePrivilege(String userId, String privilegeName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing privilege " + privilegeName + " from user " + userId));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            ValidationUtils.assertRequiredPrivilege(privilegeName);
            GlobalPrivilegeService.doGetService().revokePrivilege(userId, privilegeName);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    static {
        LOG = LogFactory.getLog(GlobalPrivilegeService.class);
        FOR_COVERAGE = new GlobalPrivilegeService();
    }
}

