/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.membership;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.macro.security.SasPrincipalsResult;
import com.sas.lsaf.security.principal.Principal;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MembershipService {
    private static Log LOG = LogFactory.getLog(MembershipService.class);
    private static MembershipService FOR_COVERAGE = new MembershipService();

    private MembershipService() {
    }

    private static com.sas.lsaf.security.membership.MembershipService doGetService() {
        return ServiceManagerFactory.getApiMembershipService();
    }

    public static void getPotentialMembers(String path, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting potential members for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Set ps = MembershipService.doGetService().getPotentialMembers(ci, false);
            result.setPrincipals(ps);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAssignedMembers(String path, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting assigned members for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Set ps = MembershipService.doGetService().getAssignedMembers(ci);
            result.setPrincipals(ps);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isMember(String path, SasPrincipalDescriptor sasPrincipal, String includeImplicit, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking membership " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " in " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            Principal p = PrincipalUtils.getMemberAsPrincipal(sasPrincipal);
            boolean ii = ValidationUtils.validateBinaryFlagQuietly(includeImplicit);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            boolean isMember = MembershipService.doGetService().isMember(ci, p, ii);
            result.init(0, "Success.");
            return isMember;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void addMember(String path, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " to " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            Principal p = PrincipalUtils.getMemberAsPrincipal(sasPrincipal);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            MembershipService.doGetService().addMember(ci, p);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeMember(String path, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " from " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            Principal p = PrincipalUtils.getMemberAsPrincipal(sasPrincipal);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            MembershipService.doGetService().removeMember(ci, p);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

