/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.group;

import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.macro.security.SasPrincipalsResult;
import com.sas.lsaf.macro.security.group.SasGroupsResult;
import com.sas.lsaf.security.group.Group;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.group.GroupNotFoundException;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserDescriptor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GroupService {
    private static Log LOG = LogFactory.getLog(GroupService.class);
    private static GroupService FOR_COVERAGE = new GroupService();

    private GroupService() {
    }

    private static com.sas.lsaf.security.group.GroupService doGetService() {
        return ServiceManagerFactory.getApiGroupService();
    }

    private static String getGroupContextId(String path, String groupName) throws RepositoryItemNotFoundException {
        ValidationUtils.assertRequiredPath(path);
        ValidationUtils.validateRequiredParameter(groupName, "Group");
        return RepositoryUtils.getRepositoryItemId(path);
    }

    private static String getGroupId(String path, String groupName) throws GroupNotFoundException, RepositoryItemNotFoundException {
        String ci = GroupService.getGroupContextId(path, groupName);
        GroupDescriptor gd = GroupService.doGetService().getGroupDescriptorByName(ci, groupName);
        return gd.getId();
    }

    private static Group getGroup(String path, String groupName) throws GroupNotFoundException, RepositoryItemNotFoundException {
        String ci = GroupService.getGroupContextId(path, groupName);
        return GroupService.doGetService().getGroupByName(ci, groupName);
    }

    public static void getGroups(String path, SasGroupsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            String ci = RepositoryUtils.getRepositoryItemId(path);
            Set gds = GroupService.doGetService().getGroupDescriptors(ci);
            result.init(0, "Success.");
            result.setGroups(gds);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserGroups(String userId, String path, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for user " + userId + " path: " + path));
        }
        try {
            ValidationUtils.assertRequiredUserId(userId);
            UserDescriptor member = ServiceManagerFactory.getApiUserService().getUserDescriptorByUserId(userId);
            HashSet gds = new HashSet();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)path))) {
                gds.addAll(GroupService.doGetService().getAllReachableGroupsByMember((Principal)member));
            } else {
                String contextId = RepositoryUtils.getRepositoryItemId(path);
                gds.addAll(GroupService.doGetService().getReachableGroupsByMember(contextId, (Principal)member));
            }
            result.init(0, "Success.");
            result.setPrincipals(gds);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void create(String path, String groupName, String description, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating group " + groupName + " at " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(groupName, "Group");
            String ci = RepositoryUtils.getRepositoryItemId(path);
            GroupService.doGetService().createGroup(ci, groupName, description, null);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean exists(String path, String groupName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of group " + groupName + " at " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(groupName, "Group");
            RepositoryItem ri = ServiceManagerFactory.getApiRepositoryService().getItem(path);
            String ci = ri.getId();
            boolean exists = GroupService.doGetService().groupExists(ci, groupName);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void delete(String path, String groupName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting group " + groupName + " at " + path));
        }
        try {
            String groupId = GroupService.getGroupId(path, groupName);
            GroupService.doGetService().deleteGroup(groupId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getMembers(String path, String groupName, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting members for group " + groupName + " at " + path));
        }
        try {
            Group g = GroupService.getGroup(path, groupName);
            result.init(0, "Success.");
            result.setPrincipals(g.getMembers());
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void addMember(String path, String groupName, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " to group " + groupName + " at " + path));
        }
        try {
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            Group g = GroupService.getGroup(path, groupName);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean added = g.getMembers().add(p);
            if (added) {
                GroupService.doGetService().updateGroup(g);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeMember(String path, String groupName, SasPrincipalDescriptor sasPrincipal, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " from group " + groupName + " at " + path));
        }
        try {
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            Group g = GroupService.getGroup(path, groupName);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean removed = g.getMembers().remove(p);
            if (removed) {
                GroupService.doGetService().updateGroup(g);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isMember(String path, String groupName, SasPrincipalDescriptor sasPrincipal, String includeImplicit, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking member " + sasPrincipal.getType() + ":" + sasPrincipal.getName() + " in group " + groupName + " at " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(groupName, "Group");
            PrincipalUtils.validateMemberSasPrincipalDescriptor(sasPrincipal);
            boolean ii = ValidationUtils.validateBinaryFlagQuietly(includeImplicit);
            String gid = GroupService.getGroupId(path, groupName);
            Principal p = PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
            boolean isMember = GroupService.doGetService().isMember(gid, p, ii);
            result.init(0, "Success.");
            return isMember;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }
}

