/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.authentication;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.client.ProxyInfo;
import com.sas.lsaf.client.SessionFactory;
import com.sas.lsaf.client.impl.TrustedContextHolder;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.StringUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.authentication.LsafAuthenticationException;
import com.sas.lsaf.macro.security.authentication.LsafSessionMissingException;
import com.sas.lsaf.security.authentication.AuthenticationException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LsafSessionHolder {
    private static final Log LOG = LogFactory.getLog((String)LsafSessionHolder.class.getName());
    private static final String MACROS_TRUSTED_PROPERTY = "sas.lsaf.macros.trusted";
    private static ClientSession activeSession;
    private static boolean trusted;
    private static LsafSessionHolder FOR_COVERAGE;

    private LsafSessionHolder() {
    }

    static void initialize() {
        trusted = false;
        String macrosTrustedPropertyString = System.getProperty(MACROS_TRUSTED_PROPERTY);
        if (macrosTrustedPropertyString != null && macrosTrustedPropertyString.equalsIgnoreCase(Boolean.TRUE.toString())) {
            LOG.info((Object)"Macros are running in trusted context mode");
            trusted = true;
        }
    }

    static void setTrusted(boolean isTrusted) {
        trusted = isTrusted;
    }

    public static boolean isTrusted() {
        return trusted;
    }

    public static boolean hasSession() {
        try {
            ClientSession s = LsafSessionHolder.getSession();
            return s != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ClientSession getSession() throws AuthenticationException, MalformedURLException {
        if (activeSession != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Active session exists: " + String.valueOf(activeSession)));
            }
            try {
                ServiceManagerFactory.getAPIServiceManager(activeSession).getTypeService().typeExists("test");
                return activeSession;
            }
            catch (Exception e) {
                if (trusted) {
                    LOG.info((Object)"Failure communicating with server - attempting to reconnect");
                } else {
                    LOG.info((Object)"Failure communicating with server", (Throwable)e);
                }
                activeSession = null;
            }
        }
        if (!trusted) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No active session exists");
            }
            throw new LsafSessionMissingException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Attempting to establish trusted context session");
        }
        TrustedContextHolder contextHolder = new TrustedContextHolder();
        String userid = contextHolder.getUserId();
        String url = contextHolder.getUrl();
        String token = contextHolder.getToken();
        if (userid == null || userid.isEmpty() || url == null || url.isEmpty() || token == null || token.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Context holder values have not been set.  userid: " + userid + " url: " + url));
            }
            throw new LsafSessionMissingException();
        }
        byte[] pw = token.getBytes();
        ClientSession session = SessionFactory.logon((URL)new URL(url), (String)userid, (byte[])pw);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trusted session created: " + String.valueOf(session)));
        }
        activeSession = session;
        return activeSession;
    }

    public static ClientSession createSession(String url, String userId, String password, String proxyHost, String proxyPort, String proxyUserId, String proxyPassword) throws MalformedURLException, AuthenticationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating session for user: " + userId + " to system: " + url));
        }
        if (trusted) {
            LOG.info((Object)("Login attempted during trusted session, user: " + userId + " to system: " + url));
            throw new LsafAuthenticationException("This macro is not allowed when running in an active SAS Life Science Analytics Framework session.");
        }
        if (activeSession != null) {
            throw new LsafAuthenticationException("There is already an active session.");
        }
        ValidationUtils.validateRequiredParameter(url, "URL");
        ValidationUtils.assertRequiredUserId(userId);
        ValidationUtils.assertRequiredPassword(password);
        ProxyInfo proxyInfo = null;
        String[] parms = new String[]{proxyHost, proxyPort, proxyUserId, proxyPassword};
        boolean haveProxyParms = false;
        for (String p : parms) {
            if (ValidationUtils.valueIsMissing((Serializable)((Object)p))) continue;
            haveProxyParms = true;
            break;
        }
        if (haveProxyParms) {
            ValidationUtils.validateRequiredParameter(proxyHost, "Proxy host");
            if (ValidationUtils.valueIsMissing((Serializable)((Object)proxyPort))) {
                throw new LsafAuthenticationException("If connecting through a proxy server, the proxy port number parameter is required.");
            }
            int pport = 0;
            try {
                pport = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                throw new LsafAuthenticationException("The proxy port parameter must be an integer.");
            }
            proxyInfo = new ProxyInfo(StringUtils.strip(proxyHost), pport, StringUtils.strip(proxyUserId), StringUtils.strip(proxyPassword));
        }
        try {
            URL serverURL = new URL(url);
            byte[] pw = password.getBytes();
            ClientSession session = proxyInfo == null ? SessionFactory.logon((URL)serverURL, (String)userId, (byte[])pw) : SessionFactory.logon((URL)serverURL, (String)userId, (byte[])pw, proxyInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ClientSession created: " + session.toString()));
            }
            activeSession = session;
            return activeSession;
        }
        catch (IllegalArgumentException e) {
            throw new ResultException(-1, e.getLocalizedMessage());
        }
    }

    public static void destroySession() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Destroying session: " + String.valueOf(activeSession)));
        }
        if (trusted) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempted to destroy trusted session: " + String.valueOf(activeSession)));
            }
            throw new LsafAuthenticationException("This macro is not allowed when running in an active SAS Life Science Analytics Framework session.");
        }
        if (activeSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempted to destroy non-existent session");
            }
            throw new LsafSessionMissingException();
        }
        activeSession.logoff();
        activeSession = null;
    }

    static {
        FOR_COVERAGE = new LsafSessionHolder();
        LsafSessionHolder.initialize();
    }
}

