/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.authentication;

import com.sas.lsaf.client.ClientSession;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.security.authentication.LsafAuthenticationException;
import com.sas.lsaf.macro.security.authentication.LsafSessionHolder;
import com.sas.lsaf.security.authentication.AuthenticationException;
import java.net.MalformedURLException;

public final class AuthenticationService {
    private static AuthenticationService FOR_COVERAGE = new AuthenticationService();
    public static final String SESSION_TERMINATED_MESSAGE = "The Life Sciences and Analytic Framework session was successfully terminated.";

    private AuthenticationService() {
    }

    public static void login(String url, String userId, String password, String proxyHost, String proxyPort, String proxyUserId, String proxyPassword, Result result) {
        try {
            LsafSessionHolder.createSession(url, userId, password, proxyHost, proxyPort, proxyUserId, proxyPassword);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void logout(Result result) {
        try {
            LsafSessionHolder.destroySession();
            result.init(0, SESSION_TERMINATED_MESSAGE);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static ClientSession getLsafSession() {
        try {
            return LsafSessionHolder.getSession();
        }
        catch (AuthenticationException e) {
            throw new LsafAuthenticationException("An authentication error was encountered.");
        }
        catch (MalformedURLException e) {
            throw new LsafAuthenticationException(e.getLocalizedMessage());
        }
    }

    public static String getLoggedInUserId() {
        try {
            return ServiceManagerFactory.getAPIServiceManager().getUserService().getCurrentUserId();
        }
        catch (Exception e) {
            return null;
        }
    }
}

