/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.audit;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.audit.SasAuditActionsResult;
import com.sas.lsaf.security.audit.AuditAction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AuditService {
    private static final Log LOG = LogFactory.getLog(AuditService.class);
    public static Set<AuditAction> auditActions;
    private static AuditService FOR_COVERAGE;

    private AuditService() {
    }

    private static com.sas.lsaf.security.audit.AuditService doGetService() {
        return ServiceManagerFactory.getApiAuditService();
    }

    public static void getAuditActions(String typeId, SasAuditActionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting audit actions by type " + typeId));
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            if (auditActions == null) {
                auditActions = AuditService.doGetService().getAuditActions();
            }
            if (ValidationUtils.valueIsMissing((Serializable)((Object)typeId))) {
                result.setActions(auditActions);
            } else {
                HashSet<AuditAction> auditActionsByType = new HashSet<AuditAction>();
                for (AuditAction aa : auditActions) {
                    if (!aa.getTypeId().equalsIgnoreCase(typeId)) continue;
                    auditActionsByType.add(aa);
                }
                if (auditActionsByType.isEmpty()) {
                    throw new ResultException(-1, "Audit action type " + typeId + " not found.");
                }
                result.setActions(auditActionsByType);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    static {
        FOR_COVERAGE = new AuditService();
    }
}

