/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.acl;

import com.sas.lsaf.content.repository.RepositoryContainer;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.security.acl.SasAce;
import com.sas.lsaf.security.acl.AbstractAcl;
import com.sas.lsaf.security.acl.DefaultAcl;
import java.util.ArrayList;
import java.util.List;

public class SasAcl {
    private String path;
    private String name;
    private String itemType;
    private boolean isContainer;
    private String owner;
    private String ownerPropagation;
    private String aclType;
    private List<SasAce> aces;

    public SasAcl() {
    }

    public SasAcl(String path, String aclType) {
        this.path = path;
        this.name = PathUtils.getName(path);
        this.itemType = null;
        this.isContainer = false;
        this.owner = null;
        this.ownerPropagation = null;
        this.aclType = aclType;
        this.aces = new ArrayList<SasAce>();
    }

    public SasAcl(RepositoryItem item, AbstractAcl acl, AclType aclType) {
        this.path = SasUtils.toSasString(item.getPath());
        this.name = SasUtils.toSasString(item.getName());
        this.itemType = SasUtils.toSasString(item.getTypeId());
        this.isContainer = item instanceof RepositoryContainer;
        this.owner = SasUtils.toSasString(acl.getOwner() == null ? "<creator>" : acl.getOwner().getPrincipalId());
        this.setOwnerPropagation(acl);
        this.aclType = aclType.name();
        this.aces = SasAce.toSasAces(acl.getEntries());
    }

    private void setOwnerPropagation(AbstractAcl acl) {
        this.ownerPropagation = acl instanceof DefaultAcl ? ("<creator>".equals(this.owner) ? DefaultAcl.OwnerPropagation.CREATOR.name() : DefaultAcl.OwnerPropagation.USER.name()) : null;
    }

    public void setAces(List<SasAce> aces) {
        this.aces.clear();
        this.aces.addAll(aces);
    }

    public List<SasAce> getAces() {
        return this.aces;
    }

    public int getSize() {
        return this.aces.size();
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getItemType() {
        return this.itemType;
    }

    public int getIsContainer() {
        return this.isContainer ? 1 : 0;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerPropagation() {
        return this.ownerPropagation;
    }

    public String getAclType() {
        return this.aclType;
    }

    public void resetAcl(String path, String aclType) {
        this.path = path;
        this.aclType = aclType;
        this.name = PathUtils.getName(path);
        this.itemType = null;
        this.isContainer = false;
        this.owner = null;
        this.aces = new ArrayList<SasAce>();
    }

    public void addAce(String aclPrincipalType, String principalName, String groupContextPath, double adminPermission, double readPermission, double writePropertiesPermission, double writeContentPermission, double deletePermission) {
        SasAce ace = new SasAce();
        ace.setAclPrincipalType(aclPrincipalType);
        ace.setAclPrincipalName(principalName);
        ace.setGroupContextPath(groupContextPath);
        ace.setAdminPermission(adminPermission);
        ace.setReadPermission(readPermission);
        ace.setWritePropertiesPermission(writePropertiesPermission);
        ace.setWriteContentPermission(writeContentPermission);
        ace.setDeletePermission(deletePermission);
        this.aces.add(ace);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SasAcl[");
        sb.append("path: " + this.path);
        sb.append(", isContainer: " + this.isContainer);
        sb.append(", aclType: " + this.aclType);
        sb.append(", itemType: " + this.itemType);
        sb.append(", owner: " + this.owner);
        sb.append(", ownerPropagation: " + this.ownerPropagation);
        int count = 0;
        for (SasAce ace : this.aces) {
            if (++count == 1) {
                sb.append("\r\n");
            }
            sb.append("   " + String.valueOf(ace)).append("\r\n");
        }
        if (count == 0) {
            sb.append("no ACEs; ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setAclType(String aclType) {
        this.aclType = aclType;
    }

    public static enum AclType {
        CURRENT,
        DEFAULT;

    }
}

