/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.acl;

import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.macro.security.acl.SasUpdateAclResult;
import com.sas.lsaf.security.acl.AbstractAcl;
import com.sas.lsaf.security.acl.AclEntry;
import com.sas.lsaf.security.acl.AclMembers;
import com.sas.lsaf.security.acl.AclOwner;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.group.GroupNotFoundException;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.security.user.UserNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;

public class SasAce {
    private String aclPrincipalType;
    private String aclPrincipalName;
    private String groupContextPath;
    private int readPermission;
    private int writePropertiesPermission;
    private int writeContentPermission;
    private int deletePermission;
    private int adminPermission;

    public SasAce() {
    }

    public SasAce(AclEntry ace) {
        this.groupContextPath = "";
        this.adminPermission = this.doGetPermissionValue(ace.getAdminPermission());
        this.readPermission = this.doGetPermissionValue(ace.getReadPermission());
        this.writePropertiesPermission = this.doGetPermissionValue(ace.getWritePropertiesPermission());
        this.writeContentPermission = this.doGetPermissionValue(ace.getWriteContentPermission());
        this.deletePermission = this.doGetPermissionValue(ace.getDeletePermission());
        if (ace.getPrincipal() instanceof UserDescriptor) {
            this.aclPrincipalType = AceType.USER.name();
            this.aclPrincipalName = SasUtils.toSasString(ace.getPrincipal().getPrincipalId());
            return;
        }
        this.aclPrincipalName = SasUtils.toSasString(ace.getPrincipal().getPrincipalName());
        if (ace.getPrincipal() instanceof AclOwner) {
            this.aclPrincipalType = AceType.ACLOWNER.name();
        } else if (ace.getPrincipal() instanceof AclMembers) {
            this.aclPrincipalType = AceType.ACLMEMBERS.name();
        } else if (ace.getPrincipal() instanceof GroupDescriptor) {
            this.aclPrincipalType = AceType.GROUP.name();
            ObjectIdentity gci = ((GroupDescriptor)ace.getPrincipal()).getContext();
            String grpContextPath = RepositoryUtils.getPathFromItemIdentity(gci);
            this.groupContextPath = SasUtils.toSasString(grpContextPath);
        }
    }

    private int doGetPermissionValue(AclEntry.PermissionValue val) {
        return val == AclEntry.PermissionValue.TRUE ? 1 : (val == AclEntry.PermissionValue.DENY ? -1 : 0);
    }

    private static AclEntry.PermissionValue doGetPermissionValue(double value, String permission) {
        if (value == 1.0) {
            return AclEntry.PermissionValue.TRUE;
        }
        if (value == -1.0) {
            return AclEntry.PermissionValue.DENY;
        }
        if (value == 0.0) {
            return AclEntry.PermissionValue.FALSE;
        }
        String validValues = "-1, 0, and 1";
        ValidationUtils.handleInvalidParameterValue("-1, 0, and 1", "Permission value " + permission);
        return null;
    }

    private static void doValidateAclEntryType(String aceType, String aclPrincipalType) {
        AceType at = (AceType)ValidationUtils.validateUpcasedEnum(aceType, "ACE type", AceType.class);
        if (at.equals((Object)AceType.ACLOWNER) || at.equals((Object)AceType.ACLMEMBERS)) {
            String titleCase = WordUtils.capitalizeFully((String)aclPrincipalType);
            ValidationUtils.validateEnum(titleCase, "ACE principal type", AclPrincipalType.class, false);
        }
    }

    public String getAclPrincipalName() {
        return this.aclPrincipalName;
    }

    public String getAclPrincipalType() {
        return this.aclPrincipalType;
    }

    public String getGroupContextPath() {
        return this.groupContextPath;
    }

    public int getReadPermission() {
        return this.readPermission;
    }

    public int getWritePropertiesPermission() {
        return this.writePropertiesPermission;
    }

    public int getWriteContentPermission() {
        return this.writeContentPermission;
    }

    public int getDeletePermission() {
        return this.deletePermission;
    }

    public int getAdminPermission() {
        return this.adminPermission;
    }

    public void setAclPrincipalType(String aclPrincipalType) {
        this.aclPrincipalType = aclPrincipalType;
    }

    public void setAclPrincipalName(String aclPrincipalName) {
        this.aclPrincipalName = aclPrincipalName;
    }

    public void setGroupContextPath(String groupContextPath) {
        this.groupContextPath = groupContextPath;
    }

    public void setReadPermission(double readPermission) {
        this.readPermission = (int)readPermission;
    }

    public void setWritePropertiesPermission(double writePropertiesPermission) {
        this.writePropertiesPermission = (int)writePropertiesPermission;
    }

    public void setWriteContentPermission(double writeContentPermission) {
        this.writeContentPermission = (int)writeContentPermission;
    }

    public void setDeletePermission(double deletePermission) {
        this.deletePermission = (int)deletePermission;
    }

    public void setAdminPermission(double adminPermission) {
        this.adminPermission = (int)adminPermission;
    }

    public static List<SasAce> toSasAces(Set<AclEntry> aces) {
        ArrayList<SasAce> sasAces = new ArrayList<SasAce>(aces.size());
        for (AclEntry ace : aces) {
            sasAces.add(new SasAce(ace));
        }
        return sasAces;
    }

    public static AclEntry toAclEntry(AbstractAcl acl, SasAce sasAce, SasUpdateAclResult result) throws UserNotFoundException, GroupNotFoundException, RepositoryItemNotFoundException {
        AclEntry aclEntry = null;
        String apType = sasAce.getAclPrincipalType();
        String apName = sasAce.getAclPrincipalName();
        SasAce.doValidateAclEntryType(apType, apName);
        if (apType.equalsIgnoreCase(AceType.ACLOWNER.name())) {
            for (AclEntry ae : acl.getEntries()) {
                if (!(ae.getPrincipal() instanceof AclOwner)) continue;
                aclEntry = ae;
                break;
            }
        } else if (apType.equalsIgnoreCase(AceType.ACLMEMBERS.name())) {
            for (AclEntry ae : acl.getEntries()) {
                if (!(ae.getPrincipal() instanceof AclMembers)) continue;
                aclEntry = ae;
                break;
            }
        } else {
            Principal p = PrincipalUtils.getMemberAsPrincipal(new SasPrincipalDescriptor(apType, apName, sasAce.getGroupContextPath()));
            for (AclEntry ae : acl.getEntries()) {
                if (!ae.getPrincipal().getPrincipalId().equals(p.getId())) continue;
                aclEntry = ae;
                break;
            }
            if (aclEntry == null) {
                aclEntry = new AclEntry();
                aclEntry.setPrincipal(p);
            }
        }
        if (aclEntry != null) {
            aclEntry.setAdminPermission(SasAce.doGetPermissionValue(sasAce.getAdminPermission(), Permissions.admin.name()));
            aclEntry.setReadPermission(SasAce.doGetPermissionValue(sasAce.getReadPermission(), Permissions.read.name()));
            aclEntry.setWritePropertiesPermission(SasAce.doGetPermissionValue(sasAce.getWritePropertiesPermission(), Permissions.properties_write.name()));
            aclEntry.setWriteContentPermission(SasAce.doGetPermissionValue(sasAce.getWriteContentPermission(), Permissions.contents_write.name()));
            aclEntry.setDeletePermission(SasAce.doGetPermissionValue(sasAce.getDeletePermission(), Permissions.delete.name()));
            if (aclEntry.getReadPermission() == AclEntry.PermissionValue.FALSE && aclEntry.getWritePropertiesPermission() == AclEntry.PermissionValue.FALSE && aclEntry.getWriteContentPermission() == AclEntry.PermissionValue.FALSE && aclEntry.getDeletePermission() == AclEntry.PermissionValue.FALSE && aclEntry.getAdminPermission() == AclEntry.PermissionValue.FALSE) {
                result.incrementBlankAceCount();
            }
        }
        return aclEntry;
    }

    public static Set<AclEntry> toAclEntries(AbstractAcl acl, List<SasAce> sasAces, SasUpdateAclResult result) throws UserNotFoundException, GroupNotFoundException, RepositoryItemNotFoundException {
        HashSet<AclEntry> aclEntries = new HashSet<AclEntry>(sasAces.size());
        for (SasAce sasAce : sasAces) {
            aclEntries.add(SasAce.toAclEntry(acl, sasAce, result));
        }
        return aclEntries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SasAce: [");
        sb.append("aclPrincipalType: " + this.aclPrincipalType);
        sb.append(", aclPrincipalName: " + this.aclPrincipalName);
        sb.append(", groupContextPath: " + this.groupContextPath);
        sb.append(", admin: " + this.adminPermission);
        sb.append(", read: " + this.readPermission);
        sb.append(", writeProperties: " + this.writePropertiesPermission);
        sb.append(", writeContent: " + this.writeContentPermission);
        sb.append(", delete: " + this.deletePermission);
        return sb.toString();
    }

    public static enum AceType {
        ACLOWNER,
        ACLMEMBERS,
        USER,
        GROUP;

    }

    public static enum AclPrincipalType {
        Owner,
        Members;

    }

    public static enum Permissions {
        admin,
        read,
        properties_write,
        contents_write,
        delete;

    }
}

