/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security.acl;

import com.sas.lsaf.content.repository.RepositoryContainer;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.acl.SasAce;
import com.sas.lsaf.macro.security.acl.SasAcl;
import com.sas.lsaf.macro.security.acl.SasAclsResult;
import com.sas.lsaf.macro.security.acl.SasUpdateAclResult;
import com.sas.lsaf.security.acl.AbstractAcl;
import com.sas.lsaf.security.acl.Acl;
import com.sas.lsaf.security.acl.AclNotFoundException;
import com.sas.lsaf.security.acl.DefaultAcl;
import com.sas.lsaf.security.user.UserDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AclService {
    private static final Log LOG = LogFactory.getLog(AclService.class);
    private static AclService FOR_COVERAGE = new AclService();

    private AclService() {
    }

    private static com.sas.lsaf.security.acl.AclService doGetService() {
        return ServiceManagerFactory.getApiACLService();
    }

    private static SasAcl.AclType doValidateAclTypeForContainer(String value) {
        return (SasAcl.AclType)ValidationUtils.validateUpcasedEnum(value, "ACL type", SasAcl.AclType.class);
    }

    private static SasAcl.AclType doValidateAclTypeForFile(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value)) || value.equalsIgnoreCase(SasAcl.AclType.CURRENT.name())) {
            return SasAcl.AclType.CURRENT;
        }
        ValidationUtils.handleInvalidOptionalParameterValue(SasAcl.AclType.CURRENT.name(), "ACL type");
        return null;
    }

    private static List<SasAcl> doGetSasAcls(List<RepositoryItem> items) throws AclNotFoundException {
        com.sas.lsaf.security.acl.AclService srv = AclService.doGetService();
        ArrayList<SasAcl> sasAcls = new ArrayList<SasAcl>();
        for (RepositoryItem item : items) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing " + String.valueOf(item) + " type=" + item.getTypeId() + " path=" + item.getPath()));
            }
            String itemid = item.getId();
            Acl aacl = srv.getAcl(itemid);
            sasAcls.add(new SasAcl(item, (AbstractAcl)aacl, SasAcl.AclType.CURRENT));
            if (item instanceof RepositoryContainer) {
                aacl = srv.getDefaultAcl(itemid);
                sasAcls.add(new SasAcl(item, (AbstractAcl)aacl, SasAcl.AclType.DEFAULT));
            }
            item = null;
        }
        return sasAcls;
    }

    private static AbstractAcl doGetAcl(String path, String aclType) throws RepositoryItemNotFoundException, AclNotFoundException {
        RepositoryItem ri = ServiceManagerFactory.getApiRepositoryService().getItem(path);
        if (ri instanceof RepositoryFile) {
            AclService.doValidateAclTypeForFile(aclType);
            return AclService.doGetService().getAcl(ri.getId());
        }
        SasAcl.AclType at = AclService.doValidateAclTypeForContainer(aclType);
        if (at.equals((Object)SasAcl.AclType.CURRENT)) {
            return AclService.doGetService().getAcl(ri.getId());
        }
        return AclService.doGetService().getDefaultAcl(ri.getId());
    }

    private static String doGetOwnerFromUserDescriptor(UserDescriptor ownerUser) {
        if (ownerUser == null) {
            return "<creator>";
        }
        return ownerUser.getUserId();
    }

    public static String getOwner(String path, String aclType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting " + aclType + " owner for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            AbstractAcl acl = AclService.doGetAcl(path, aclType);
            String owner = AclService.doGetOwnerFromUserDescriptor(acl.getOwner());
            result.init(0, "Success.");
            return owner;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void updateOwner(String path, String aclType, String userid, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating " + aclType + " owner for " + path + " to " + userid));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredUserId(userid);
            AbstractAcl acl = AclService.doGetAcl(path, aclType);
            if (acl instanceof DefaultAcl) {
                boolean isCreator = userid.equalsIgnoreCase("<creator>");
                UserDescriptor owner = isCreator ? null : ServiceManagerFactory.getApiUserService().getUserDescriptorByUserId(userid.trim());
                ((DefaultAcl)acl).setOwnerPropagation(isCreator ? DefaultAcl.OwnerPropagation.CREATOR : DefaultAcl.OwnerPropagation.USER);
                acl.setOwner(isCreator ? null : owner);
                AclService.doGetService().updateDefaultAcl((DefaultAcl)acl);
            } else {
                UserDescriptor newOwner = ServiceManagerFactory.getApiUserService().getUserDescriptorByUserId(userid.trim());
                acl.setOwner(newOwner);
                AclService.doGetService().updateAcl((Acl)acl);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isOwner(String path, String aclType, String userid, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if " + userid + " is " + aclType + " owner for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredUserId(userid);
            String uId = userid.equalsIgnoreCase("<creator>") ? userid.toLowerCase() : userid;
            AbstractAcl acl = AclService.doGetAcl(path, aclType);
            String owner = AclService.doGetOwnerFromUserDescriptor(acl.getOwner());
            result.init(0, "Success.");
            return owner.equals(uId);
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getAcls(String path, String recursion, SasAclsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting acls for " + path + " with a depth of " + recursion));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            List<Object> sasAcls = new ArrayList();
            RepositoryItem r = ServiceManagerFactory.getApiRepositoryService().getItem(path);
            ArrayList<RepositoryItem> items = new ArrayList<RepositoryItem>();
            items.add(r);
            if (r instanceof RepositoryContainer) {
                int depth = ValidationUtils.validateRecursionGetChildren(recursion);
                if (depth > 0) {
                    items.addAll(RepositoryUtils.getChildren((RepositoryContainer)r, depth));
                    sasAcls.addAll(AclService.doGetSasAcls(items));
                    items.clear();
                } else {
                    sasAcls = AclService.doGetSasAcls(items);
                }
            } else {
                sasAcls = AclService.doGetSasAcls(items);
            }
            result.setAcls(sasAcls);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateAcl(SasAcl sasAcl, SasUpdateAclResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating acl for " + sasAcl.getPath()));
        }
        try {
            String path = sasAcl.getPath();
            ValidationUtils.assertRequiredPath(path);
            AbstractAcl acl = AclService.doGetAcl(path, sasAcl.getAclType());
            acl.setEntries(SasAce.toAclEntries(acl, sasAcl.getAces(), result));
            if (acl instanceof DefaultAcl) {
                AclService.doGetService().updateDefaultAcl((DefaultAcl)acl);
            } else {
                AclService.doGetService().updateAcl((Acl)acl);
            }
            result.incrementAclUpdateCount();
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

