/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.security.SasPrincipal;
import com.sas.lsaf.security.principal.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasPrincipalsResult
extends Result {
    private List<SasPrincipal> principals = new ArrayList<SasPrincipal>();

    public void setPrincipals(Set<? extends Principal> principals) {
        this.principals = SasPrincipalsResult.toSasPrincipals(principals);
    }

    public void setPrincipals(List<SasPrincipal> principals) {
        this.principals = principals;
    }

    public List<SasPrincipal> getPrincipals() {
        return this.principals;
    }

    public int getSize() {
        return this.principals.size();
    }

    public SasPrincipal getPrincipal(double index) {
        return this.principals.get((int)index);
    }

    public String getType(double index) {
        return this.getPrincipal(index).getType();
    }

    public String getName(double index) {
        return this.getPrincipal(index).getName();
    }

    public String getDescription(double index) {
        return this.getPrincipal(index).getDescription();
    }

    public String getContextPath(double index) {
        return this.getPrincipal(index).getGroupContext();
    }

    public boolean contains(String principalType, String principalName) {
        if (principalType == null || principalName == null) {
            return false;
        }
        for (SasPrincipal p : this.principals) {
            if (!p.getType().equals(principalType) || !p.getName().equals(principalName)) continue;
            return true;
        }
        return false;
    }

    public static List<SasPrincipal> toSasPrincipals(Set<? extends Principal> ps) {
        ArrayList<SasPrincipal> sasPrincipals = new ArrayList<SasPrincipal>(ps.size());
        for (Principal principal : ps) {
            sasPrincipals.add(new SasPrincipal(principal));
        }
        return sasPrincipals;
    }
}

