/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security;

import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserDescriptor;

public class SasPrincipal
extends SasPrincipalDescriptor {
    private String description;

    public SasPrincipal(String type, String name, String grpCntx, String description) {
        super(type, name, grpCntx);
        this.description = description;
    }

    public SasPrincipal(Principal p) {
        if (p instanceof UserDescriptor) {
            UserDescriptor ud = (UserDescriptor)p;
            this.setType("USER");
            this.setName(SasUtils.toSasString(ud.getUserId()));
            this.setGroupContext("");
            this.description = SasUtils.toSasString(ud.getDisplayName());
        } else {
            GroupDescriptor gd = (GroupDescriptor)p;
            this.setType("GROUP");
            this.setName(SasUtils.toSasString(gd.getName()));
            this.setGroupContext(RepositoryUtils.getPathFromItemIdentity(gd.getContext()));
            this.description = SasUtils.toSasString(gd.getDescription());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("SasPrincipal [");
        buf.append("Type: " + this.getType());
        buf.append(", Name: " + this.getName());
        buf.append(", GrpCntx: " + this.getGroupContext());
        buf.append(", Description: " + this.getDescription());
        return buf.toString();
    }
}

