/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.security;

import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptor;
import com.sas.lsaf.macro.security.SasPrincipalDescriptors;
import com.sas.lsaf.security.group.GroupNotFoundException;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserNotFoundException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public final class PrincipalUtils {
    private static PrincipalUtils FOR_COVERAGE = new PrincipalUtils();
    public static final String PRINCIPAL_TYPE_GROUP = "GROUP";
    public static final String PRINCIPAL_TYPE_USER = "USER";

    private static String doValidatePrincipalType(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value)) || value.equalsIgnoreCase(PRINCIPAL_TYPE_USER)) {
            return PRINCIPAL_TYPE_USER;
        }
        if (value.equalsIgnoreCase(PRINCIPAL_TYPE_GROUP)) {
            return PRINCIPAL_TYPE_GROUP;
        }
        String validValues = "USER, GROUP";
        ValidationUtils.handleInvalidParameterValue("USER, GROUP", "Member type");
        return null;
    }

    private static final Principal doGetPrincipal(SasPrincipalDescriptor sasPrincipal, String nameType) throws UserNotFoundException, GroupNotFoundException, RepositoryItemNotFoundException {
        PrincipalUtils.validateSasPrincipalDescriptor(sasPrincipal, nameType);
        return PrincipalUtils.getPrincipalFromValidatedSasPrincipal(sasPrincipal);
    }

    public static final Principal getMemberAsPrincipal(SasPrincipalDescriptor sasPrincipal) throws UserNotFoundException, GroupNotFoundException, RepositoryItemNotFoundException {
        return PrincipalUtils.doGetPrincipal(sasPrincipal, "Member name");
    }

    public static Set<Principal> convertSasPrincipalsToApiPrincipals(String nameType, SasPrincipalDescriptors pfPrincipals) throws Exception {
        HashSet<Principal> apiPrincipals = new HashSet<Principal>(0);
        for (SasPrincipalDescriptor sp : pfPrincipals.getList()) {
            Principal p = PrincipalUtils.doGetPrincipal(sp, nameType);
            apiPrincipals.add(p);
        }
        return apiPrincipals;
    }

    public static void validateSasPrincipalDescriptor(SasPrincipalDescriptor sasPrincipal, String nameType) {
        ValidationUtils.validateHaveLsafSession();
        String pType = PrincipalUtils.doValidatePrincipalType(sasPrincipal.getType());
        ValidationUtils.validateRequiredParameter(sasPrincipal.getName(), nameType);
        if (PRINCIPAL_TYPE_GROUP.equalsIgnoreCase(pType)) {
            ValidationUtils.validateRequiredParameter(sasPrincipal.getGroupContext(), "Group context path");
        }
        sasPrincipal.setType(pType);
    }

    public static void validateMemberSasPrincipalDescriptor(SasPrincipalDescriptor sasPrincipal) {
        PrincipalUtils.validateSasPrincipalDescriptor(sasPrincipal, "Member name");
    }

    public static Principal getPrincipalFromValidatedSasPrincipal(SasPrincipalDescriptor sasPrincipal) throws UserNotFoundException, GroupNotFoundException, RepositoryItemNotFoundException {
        switch (sasPrincipal.getType().toUpperCase()) {
            case "USER": {
                return ServiceManagerFactory.getApiUserService().getUserDescriptorByUserId(sasPrincipal.getName());
            }
            case "GROUP": {
                String contextId = RepositoryUtils.getRepositoryItemId(sasPrincipal.getGroupContext());
                return ServiceManagerFactory.getApiGroupService().getGroupDescriptorByName(contextId, sasPrincipal.getName());
            }
        }
        return null;
    }
}

