/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.query;

import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.SasDataTypeException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.query.SasQueryRecord;
import com.sas.lsaf.macro.query.SasQueryRecords;
import com.sas.lsaf.macro.query.SasQueryValidatedRecord;
import com.sas.lsaf.macro.query.SasValidatedQueryData;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Comparison;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.Constraint;
import com.sas.lsaf.query.Order;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SasQueryValidationHelper {
    private static SasQueryValidationHelper FOR_COVERAGE = new SasQueryValidationHelper();
    public static final List<String> VALID_CONSTRAINTRANGE_TYPES = Arrays.asList("LONG", "INTEGER", "DATE");
    public static final String VALMSG_REQUIRED = "Required value not specified for ";
    public static final String VALMSG_INVALID = "Invalid value specified for ";
    public static final String VALMSG_VALUE_TYPE_MISMATCH = "Invalid value specified when column type is ";
    public static final String VALMSG_CONSTRAINTRANGE_VALUEFORMAT = "Expecting two comma-separated values of same type";
    public static final String VALMSG_CONSTRAINTRANGE_VALUERANGE = "Start value does not precede end value.";
    public static final String VALMSG_CONSTRAINTRANGE_COLUMNTYPE = "Records of type " + String.valueOf((Object)QueryRecordType.CONSTRAINT_RANGE) + " are only applicable to types: " + SasUtils.toSasCommaDelimitedString(VALID_CONSTRAINTRANGE_TYPES);
    public static final String VALMSG_MULTIPLE_OPERATOR_RECORDS = "More than one record of type " + QueryRecordType.LOGICAL_OPERATOR.name() + " is not allowed.";
    public static final String VALMSG_ORDER_DUPLICATE = "Duplicate value for order record type: ";
    public static final String VALMSG_ORDER_INTEGER = "Value must be an integer.";
    private static SasQueryValidatedRecord currentRecordItem;
    private static QueryRecordType currentRecordType;
    private static Column.Type currentColumnType;
    private static boolean recordIsInvalid;
    private static Column lsafColumn;
    private static Set<String> allowableColumnClasses;
    private static List<SasQueryValidatedRecord> validatedRecordData;
    private static int invalidRecordsCount;

    private static boolean isSelectRecord() {
        return QueryRecordType.SELECT.equals((Object)currentRecordType);
    }

    private static boolean isLogicalOperatorRecord() {
        return QueryRecordType.LOGICAL_OPERATOR.equals((Object)currentRecordType);
    }

    private static boolean isAnyOrderRecord() {
        return currentRecordType.name().startsWith("ORDER");
    }

    private static boolean isConstraintRecord() {
        return currentRecordType.name().equals("CONSTRAINT");
    }

    private static boolean isRangeConstraintRecord() {
        return currentRecordType.name().indexOf("RANGE") > -1;
    }

    private static boolean isTypeBoolean() {
        return Column.Type.BOOLEAN.equals((Object)currentColumnType);
    }

    private static boolean isTypeLong() {
        return Column.Type.LONG.equals((Object)currentColumnType);
    }

    private static boolean isTypeInteger() {
        return Column.Type.INTEGER.equals((Object)currentColumnType);
    }

    private static boolean isTypeDate() {
        return Column.Type.DATE.equals((Object)currentColumnType);
    }

    private static void doAddRecordToResult() {
        validatedRecordData.add(currentRecordItem);
    }

    private static void doAddInvalidRecordToResult(String validationNote) {
        currentRecordItem.setValidationNote(validationNote);
        SasQueryValidationHelper.doAddRecordToResult();
        recordIsInvalid = true;
        ++invalidRecordsCount;
    }

    private static boolean handledRequiredValueMissing(String valueType, String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_REQUIRED + valueType);
        }
        return recordIsInvalid;
    }

    private static String doGetInvalidValueMessage(String parameterType) {
        return VALMSG_INVALID + parameterType + ".";
    }

    private static Column doValidateColumnData(List<Column> allowableColumns) {
        Column lsafColumn = null;
        String parmType = "Column Class";
        String columnClass = currentRecordItem.getColumnClass();
        if (SasQueryValidationHelper.handledRequiredValueMissing(parmType, columnClass)) {
            return null;
        }
        if (!allowableColumnClasses.contains(columnClass = columnClass.trim().toUpperCase())) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(SasQueryValidationHelper.doGetInvalidValueMessage(parmType));
            return null;
        }
        parmType = "Column Name";
        String columnName = currentRecordItem.getColumnName();
        if (SasQueryValidationHelper.handledRequiredValueMissing(parmType, columnName)) {
            return null;
        }
        columnName = columnName.trim();
        for (Column col : allowableColumns) {
            if (!col.getQueryClass().equalsIgnoreCase(columnClass) || !col.getName().equalsIgnoreCase(columnName)) continue;
            lsafColumn = col;
            break;
        }
        if (lsafColumn == null) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(SasQueryValidationHelper.doGetInvalidValueMessage(parmType));
        }
        return lsafColumn;
    }

    private static boolean doValidateCaseSensitive() {
        int iscs = currentRecordItem.getIsCaseSensitive();
        try {
            String csString = iscs == Integer.MIN_VALUE ? "" : Integer.valueOf(iscs).toString();
            return ValidationUtils.validateBinaryFlagDefaultTrue(csString, "Case-sensitive");
        }
        catch (Exception ex) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(ex.getLocalizedMessage());
            return true;
        }
    }

    private static Comparison doValidateConstraintData(Column lsafColumn) {
        String parmValue = currentRecordItem.getComparator();
        Comparison.Operator comparator = null;
        try {
            comparator = (Comparison.Operator)ValidationUtils.validateUpcasedEnum(parmValue, "Constraint comparator", Comparison.Operator.class);
        }
        catch (Exception ex) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(ex.getLocalizedMessage());
            return null;
        }
        boolean isCaseSensitive = SasQueryValidationHelper.doValidateCaseSensitive();
        if (recordIsInvalid) {
            return null;
        }
        String itemValue = currentRecordItem.getValue();
        Serializable queryValue = null;
        if (!Comparison.Operator.EQUAL.equals((Object)comparator) && !Comparison.Operator.NOT_EQUAL.equals((Object)comparator)) {
            if (SasQueryValidationHelper.handledRequiredValueMissing("When comparator is " + comparator.name() + ", value", itemValue)) {
                return null;
            }
            queryValue = SasQueryValidationHelper.doValidateValueByType(itemValue);
        } else {
            Serializable serializable = queryValue = ValidationUtils.valueIsMissing((Serializable)((Object)itemValue)) ? null : SasQueryValidationHelper.doValidateValueByType(itemValue.trim());
        }
        if (recordIsInvalid) {
            return null;
        }
        SasQueryValidationHelper.doAddRecordToResult();
        Comparison comp = new Comparison(lsafColumn, comparator, queryValue, isCaseSensitive);
        return comp;
    }

    private static Condition doValidateConstraintRangeData(Column lsafColumn) {
        Long longEnd;
        Long longStart;
        String lsafColumnType = lsafColumn.getType().name();
        if (!VALID_CONSTRAINTRANGE_TYPES.contains(lsafColumnType)) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_CONSTRAINTRANGE_COLUMNTYPE);
            return null;
        }
        String itemValue = currentRecordItem.getValue().trim();
        String[] values = SasUtils.getArrayFromSasCommaDelimitedString(itemValue);
        if (values == null || values.length != 2) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_CONSTRAINTRANGE_VALUEFORMAT);
            return null;
        }
        Serializable fromValue = SasQueryValidationHelper.doValidateValueByType(values[0]);
        if (recordIsInvalid) {
            return null;
        }
        Serializable toValue = SasQueryValidationHelper.doValidateValueByType(values[1]);
        if (recordIsInvalid) {
            return null;
        }
        boolean isValidRange = true;
        if (SasQueryValidationHelper.isTypeInteger()) {
            Integer intStart = (Integer)fromValue;
            Integer intEnd = (Integer)toValue;
            if (intStart.compareTo(intEnd) > 0) {
                isValidRange = false;
            }
        } else if ((SasQueryValidationHelper.isTypeLong() || SasQueryValidationHelper.isTypeDate()) && (longStart = (Long)fromValue).compareTo(longEnd = (Long)toValue) > 0) {
            isValidRange = false;
        }
        if (!isValidRange) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_CONSTRAINTRANGE_VALUERANGE);
            return null;
        }
        SasQueryValidationHelper.doAddRecordToResult();
        ArrayList<Comparison> constraints = new ArrayList<Comparison>();
        constraints.add(new Comparison(lsafColumn, Comparison.Operator.GREATER_THAN_OR_EQUAL, fromValue));
        constraints.add(new Comparison(lsafColumn, Comparison.Operator.LESS_THAN_OR_EQUAL, toValue));
        return new Condition(Condition.Operator.AND, constraints);
    }

    private static Serializable doValidateValueByType(String itemValue) {
        Object valType = null;
        try {
            Comparable<Boolean> queryValue = null;
            if (SasQueryValidationHelper.isTypeBoolean()) {
                queryValue = ValidationUtils.validateBooleanProperty("Value", itemValue);
            } else if (SasQueryValidationHelper.isTypeLong()) {
                valType = "LONG";
                queryValue = ValidationUtils.validateLongValue("Value", itemValue);
            } else if (SasQueryValidationHelper.isTypeInteger()) {
                valType = "INTEGER";
                queryValue = ValidationUtils.validateRequiredIntegerValue("Value", itemValue);
            } else if (SasQueryValidationHelper.isTypeDate()) {
                Date valueAsDate = ValidationUtils.validateDateString("Value", itemValue);
                queryValue = valueAsDate.getTime();
            } else {
                return itemValue;
            }
            return queryValue;
        }
        catch (SasDataTypeException ex) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_VALUE_TYPE_MISMATCH + String.valueOf((Object)(valType == null ? ex.getType() : valType)));
        }
        catch (Exception ex) {
            SasQueryValidationHelper.doAddInvalidRecordToResult(ex.getLocalizedMessage());
        }
        return null;
    }

    public static SasValidatedQueryData validateSasQueryData(SasQueryRecords sasQueryData, List<Column> validQueryColumns) {
        SasValidatedQueryData allValidatedQueryData = new SasValidatedQueryData();
        validatedRecordData = new ArrayList<SasQueryValidatedRecord>();
        invalidRecordsCount = 0;
        for (Column col : validQueryColumns) {
            allowableColumnClasses.add(col.getQueryClass().toUpperCase());
        }
        ArrayList<Column> lsafQuerySelects = new ArrayList<Column>();
        ArrayList<Order> lsafQueryOrders = new ArrayList<Order>();
        HashMap<String, List<Constraint>> lsafConstraintsMap = new HashMap<String, List<Constraint>>();
        Condition.Operator queryLogicalOperator = null;
        HashMap<String, Order> tempOrderMap = new HashMap<String, Order>();
        for (SasQueryRecord item : sasQueryData.getQueryRecords()) {
            currentRecordItem = new SasQueryValidatedRecord(item);
            recordIsInvalid = false;
            String parmType = "Record Type";
            String parmValue = currentRecordItem.getRecordType();
            try {
                currentRecordType = (QueryRecordType)ValidationUtils.validateUpcasedEnum(parmValue, "Record type", QueryRecordType.class);
            }
            catch (Exception ex) {
                SasQueryValidationHelper.doAddInvalidRecordToResult(ex.getLocalizedMessage());
            }
            if (recordIsInvalid) continue;
            if (!SasQueryValidationHelper.isLogicalOperatorRecord()) {
                lsafColumn = SasQueryValidationHelper.doValidateColumnData(validQueryColumns);
                if (recordIsInvalid) continue;
                currentColumnType = lsafColumn.getType();
                currentRecordItem.setColumnType(currentColumnType.name());
                if (SasQueryValidationHelper.isSelectRecord()) {
                    lsafQuerySelects.add(lsafColumn);
                    SasQueryValidationHelper.doAddRecordToResult();
                    continue;
                }
            }
            String itemValue = null;
            if (!SasQueryValidationHelper.isConstraintRecord()) {
                parmType = "Value";
                itemValue = currentRecordItem.getValue();
                if (SasQueryValidationHelper.handledRequiredValueMissing(parmType, itemValue)) continue;
                itemValue = itemValue.trim();
            }
            if (SasQueryValidationHelper.isLogicalOperatorRecord()) {
                if (queryLogicalOperator != null) {
                    SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_MULTIPLE_OPERATOR_RECORDS);
                    continue;
                }
                try {
                    queryLogicalOperator = (Condition.Operator)ValidationUtils.validateUpcasedEnum(itemValue, "Logical operator", Condition.Operator.class);
                    SasQueryValidationHelper.doAddRecordToResult();
                }
                catch (Exception ex) {
                    SasQueryValidationHelper.doAddInvalidRecordToResult(ex.getLocalizedMessage());
                }
                continue;
            }
            if (SasQueryValidationHelper.isAnyOrderRecord()) {
                boolean isAscending = QueryRecordType.ORDER_ASCENDING.equals((Object)currentRecordType);
                boolean isCaseSensitive = SasQueryValidationHelper.doValidateCaseSensitive();
                if (recordIsInvalid) continue;
                parmType = "Order";
                try {
                    ValidationUtils.validateRequiredIntegerValue(parmType, itemValue);
                    if (tempOrderMap.containsKey(itemValue)) {
                        SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_ORDER_DUPLICATE + itemValue);
                        continue;
                    }
                    Order order = new Order(lsafColumn, isAscending, isCaseSensitive);
                    tempOrderMap.put(itemValue, order);
                    SasQueryValidationHelper.doAddRecordToResult();
                }
                catch (Exception ex) {
                    SasQueryValidationHelper.doAddInvalidRecordToResult(VALMSG_ORDER_INTEGER);
                }
                continue;
            }
            Object constraint = SasQueryValidationHelper.isRangeConstraintRecord() ? SasQueryValidationHelper.doValidateConstraintRangeData(lsafColumn) : SasQueryValidationHelper.doValidateConstraintData(lsafColumn);
            String key = currentRecordItem.getColumnClass() + "__" + currentRecordItem.getColumnName();
            List<Constraint> cList = lsafConstraintsMap.get(key);
            if (cList == null) {
                cList = new ArrayList<Constraint>();
            }
            cList.add((Constraint)constraint);
            lsafConstraintsMap.put(key, cList);
        }
        allValidatedQueryData.setInvalidRecordsCount(invalidRecordsCount);
        if (lsafQuerySelects.size() == 0) {
            lsafQuerySelects.addAll(validQueryColumns);
        }
        if (!tempOrderMap.isEmpty()) {
            ArrayList keys = new ArrayList();
            keys.addAll(tempOrderMap.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                lsafQueryOrders.add((Order)tempOrderMap.get(k));
            }
        }
        allValidatedQueryData.updateQueryData(validatedRecordData, lsafQuerySelects, lsafQueryOrders, lsafConstraintsMap, queryLogicalOperator);
        return allValidatedQueryData;
    }

    static {
        currentRecordType = null;
        currentColumnType = null;
        recordIsInvalid = false;
        lsafColumn = null;
        allowableColumnClasses = new HashSet<String>();
        invalidRecordsCount = 0;
    }

    public static enum QueryRecordType {
        SELECT,
        ORDER_ASCENDING,
        ORDER_DESCENDING,
        CONSTRAINT,
        CONSTRAINT_RANGE,
        LOGICAL_OPERATOR;

    }
}

