/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.query;

import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.query.QueryService;
import com.sas.lsaf.macro.query.SasQueryRecord;
import com.sas.lsaf.macro.query.SasQueryValidationHelper;
import com.sas.lsaf.macro.security.authentication.AuthenticationService;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Comparison;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.audit.AuditEntryDetailQuery;
import com.sas.lsaf.query.audit.AuditEntryQuery;
import com.sas.lsaf.query.repository.RepositoryContainerQuery;
import com.sas.lsaf.query.repository.RepositoryFileQuery;
import com.sas.lsaf.query.repository.RepositoryFileVersionQuery;
import com.sas.lsaf.query.repository.RepositoryItemQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinFileQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinItemQuery;
import com.sas.lsaf.query.security.membership.DistinctContextMembershipQuery;
import com.sas.lsaf.query.security.membership.MembershipQuery;
import com.sas.lsaf.query.security.permissions.PermissionsQuery;
import com.sas.lsaf.security.audit.AuditEntry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public final class SasQuerySampleDataHelper {
    private static SasQuerySampleDataHelper FOR_COVERAGE = new SasQuerySampleDataHelper();
    public static final int CASE_NULL = Integer.MIN_VALUE;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static String SAMPLE_DATE_START;
    private static String SAMPLE_DATE_END;
    private static String LOGGEDIN_USER;
    private static List<SasQueryRecord> sampleRecords;

    private static void doAddSampleOperatorRecord(Condition.Operator operator) {
        sampleRecords.add(new SasQueryRecord(SasQueryValidationHelper.QueryRecordType.LOGICAL_OPERATOR.name(), null, null, operator.name(), null, Integer.MIN_VALUE));
    }

    private static void doAddSampleSelectRecord(Column column) {
        sampleRecords.add(new SasQueryRecord(SasQueryValidationHelper.QueryRecordType.SELECT.name(), column.getQueryClass(), column.getName(), null, null, Integer.MIN_VALUE));
    }

    private static void doAddSampleOrderRecord(Column column, String value, boolean asAscending, int isCaseSensitive) {
        SasQueryValidationHelper.QueryRecordType qrt = asAscending ? SasQueryValidationHelper.QueryRecordType.ORDER_ASCENDING : SasQueryValidationHelper.QueryRecordType.ORDER_DESCENDING;
        sampleRecords.add(new SasQueryRecord(qrt.name(), column.getQueryClass(), column.getName(), value, null, isCaseSensitive));
    }

    private static void doAddSampleConstraintRecord(Column column, String value, String operator, int isCaseSensitive) {
        sampleRecords.add(new SasQueryRecord(SasQueryValidationHelper.QueryRecordType.CONSTRAINT.name(), column.getQueryClass(), column.getName(), value, operator, isCaseSensitive));
    }

    private static void doAddSampleConstraintRangeRecord(Column column, String value) {
        sampleRecords.add(new SasQueryRecord(SasQueryValidationHelper.QueryRecordType.CONSTRAINT_RANGE.name(), column.getQueryClass(), column.getName(), value, null, Integer.MIN_VALUE));
    }

    private static void doAddSampleConstraintDateRangeRecords(Column column) {
        SasQuerySampleDataHelper.doAddSampleConstraintRangeRecord(column, SAMPLE_DATE_START + ", " + SAMPLE_DATE_END);
    }

    private static void doSetAuditQuerySharedSelects() {
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_ID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_ACTION);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_TIMESTAMP);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_USERID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryQuery.AUDIT_ENTRY_MODE);
    }

    private static void doSetAuditQuerySampleData(QueryService.QueryType type) {
        if (QueryService.QueryType.AUDITENTRYQUERY.equals((Object)type)) {
            SasQuerySampleDataHelper.doSetAuditQuerySharedSelects();
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID, "sas:file", Comparison.Operator.EQUAL.name(), 0);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_SOURCE_TYPE_ID, "sas:folder", Comparison.Operator.EQUAL.name(), 0);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_USERID, LOGGEDIN_USER, Comparison.Operator.EQUAL.name(), 1);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_ACTION, "DELETED", Comparison.Operator.NOT_EQUAL.name(), 0);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_MODE, AuditEntry.Mode.USER.name(), Comparison.Operator.EQUAL.name(), 1);
            SasQuerySampleDataHelper.doAddSampleConstraintDateRangeRecords(AuditEntryQuery.AUDIT_ENTRY_TIMESTAMP);
            SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
        } else if (QueryService.QueryType.AUDITENTRYDETAILQUERY.equals((Object)type)) {
            SasQuerySampleDataHelper.doSetAuditQuerySharedSelects();
            SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ID);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_ID);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_NAME);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_OLD_VALUE);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_NEW_VALUE);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryDetailQuery.AUDIT_ENTRY_DETAIL_ATTRIBUTE_ID, "PRIVILEGE_MANAGE_CHECKED*_FILES", Comparison.Operator.LIKE.name(), 0);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(AuditEntryQuery.AUDIT_ENTRY_MODE, AuditEntry.Mode.ADMIN.name(), Comparison.Operator.EQUAL.name(), 1);
            SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.OR);
        }
        SasQuerySampleDataHelper.doAddSampleOrderRecord(AuditEntryQuery.AUDIT_ENTRY_USERID, "2", true, 1);
        SasQuerySampleDataHelper.doAddSampleOrderRecord(AuditEntryQuery.AUDIT_ENTRY_TIMESTAMP, "1", false, Integer.MIN_VALUE);
    }

    private static void doSetMembershipQuerySampleData(QueryService.QueryType type) {
        if (QueryService.QueryType.CONTEXTMEMBERSHIP.equals((Object)type)) {
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.PRINCIPAL_TYPE);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.CONTEXT_QUERIED);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.PRINCIPAL_NAME);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.EXPLICIT);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(MembershipQuery.PRINCIPAL_NAME, LOGGEDIN_USER, Comparison.Operator.NOT_EQUAL.name(), 0);
            SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
            SasQuerySampleDataHelper.doAddSampleOrderRecord(MembershipQuery.PRINCIPAL_NAME, "2", true, 1);
        } else if (QueryService.QueryType.DISTINCTCONTEXTMEMBERSHIP.equals((Object)type)) {
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.PRINCIPAL_TYPE);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.CONTEXT_QUERIED);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(MembershipQuery.PRINCIPAL_NAME);
            SasQuerySampleDataHelper.doAddSampleSelectRecord(DistinctContextMembershipQuery.IMPLICIT);
            SasQuerySampleDataHelper.doAddSampleConstraintRecord(MembershipQuery.PRINCIPAL_NAME, LOGGEDIN_USER, Comparison.Operator.NOT_EQUAL.name(), 0);
            SasQuerySampleDataHelper.doAddSampleOrderRecord(MembershipQuery.PRINCIPAL_NAME, "2", true, 1);
            SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.OR);
        }
    }

    private static void doSetRepositorySampleData(QueryService.QueryType type) {
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryItemQuery.TYPE_ID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryItemQuery.NAME);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryItemQuery.PATH);
        switch (type) {
            case ITEM: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryItemQuery.STATE);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryItemQuery.STATE, RepositoryItem.State.ACTIVE.name(), Comparison.Operator.NOT_EQUAL.name(), 0);
                break;
            }
            case FILE: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileQuery.VERSIONED);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileQuery.SIZE);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileQuery.SIGNING_STATUS);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileQuery.MINOR_VERSION_LIMIT);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileQuery.VERSIONED, "1", Comparison.Operator.EQUAL.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileQuery.SIZE, "500", Comparison.Operator.GREATER_THAN.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileQuery.SIGNING_STATUS, RepositoryFile.SigningStatus.NONE.name(), Comparison.Operator.EQUAL.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileQuery.MINOR_VERSION_LIMIT, "12", Comparison.Operator.NOT_EQUAL.name(), 0);
                break;
            }
            case FILEVERSION: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileVersionQuery.TOTAL_VERSIONS);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileVersionQuery.SIGNED);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileVersionQuery.VERSION_CREATED);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileVersionQuery.VERSION_CREATED_BY);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryFileVersionQuery.VERSION);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileVersionQuery.TOTAL_VERSIONS, "3", Comparison.Operator.EQUAL.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryFileVersionQuery.SIGNED, "1", Comparison.Operator.NOT_EQUAL.name(), 0);
                break;
            }
            case CONTAINER: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.OR);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryContainerQuery.DEFAULT_MAJOR_VERSION_LIMIT);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryContainerQuery.DEFAULT_MINOR_VERSION_LIMIT);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryContainerQuery.DEFAULT_MAJOR_VERSION_LIMIT, "1", Comparison.Operator.EQUAL.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RepositoryContainerQuery.DEFAULT_MINOR_VERSION_LIMIT, "500", Comparison.Operator.GREATER_THAN.name(), 0);
                break;
            }
        }
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RepositoryItemQuery.CREATED);
        SasQuerySampleDataHelper.doAddSampleConstraintDateRangeRecords(RepositoryItemQuery.CREATED);
        SasQuerySampleDataHelper.doAddSampleOrderRecord(RepositoryItemQuery.PATH, "1", true, 0);
        SasQuerySampleDataHelper.doAddSampleOrderRecord(RepositoryItemQuery.NAME, "2", true, 0);
    }

    private static void doSetRecycleBinQuerySampleData(QueryService.QueryType type) {
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinItemQuery.TYPE_ID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinItemQuery.PATH);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinItemQuery.DELETED_BY);
        SasQuerySampleDataHelper.doAddSampleConstraintRecord(RecycleBinItemQuery.DELETED_BY, AuthenticationService.getLoggedInUserId(), Comparison.Operator.EQUAL.name(), 0);
        switch (type) {
            case ITEM: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinItemQuery.LAST_MODIFIED_BY);
                break;
            }
            case FILE: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.OR);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.SIZE);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.VERSION);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.TOTAL_VERSIONS);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.TOTAL_SIZE);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RecycleBinFileQuery.SIZE, "500", Comparison.Operator.GREATER_THAN.name(), 0);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RecycleBinFileQuery.TOTAL_VERSIONS, "2", Comparison.Operator.GREATER_THAN.name(), 0);
                break;
            }
            case FILEVERSION: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.TOTAL_VERSIONS);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.VERSION);
                SasQuerySampleDataHelper.doAddSampleConstraintRecord(RecycleBinFileQuery.TOTAL_VERSIONS, "3", Comparison.Operator.EQUAL.name(), 0);
                break;
            }
            case CONTAINER: {
                SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.OR);
                SasQuerySampleDataHelper.doAddSampleSelectRecord(RecycleBinFileQuery.SIZE);
                break;
            }
        }
        SasQuerySampleDataHelper.doAddSampleOrderRecord(RecycleBinItemQuery.DELETED_BY, "1", true, 0);
        SasQuerySampleDataHelper.doAddSampleOrderRecord(RecycleBinItemQuery.PATH, "2", true, 0);
    }

    private static void doSetPermissionsSampleData() {
        SasQuerySampleDataHelper.doAddSampleSelectRecord(PermissionsQuery.PATH);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(PermissionsQuery.TYPE);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(PermissionsQuery.OWNER);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(PermissionsQuery.USERID);
        SasQuerySampleDataHelper.doAddSampleSelectRecord(PermissionsQuery.PERMISSIONS);
        SasQuerySampleDataHelper.doAddSampleConstraintRecord(PermissionsQuery.USERID, AuthenticationService.getLoggedInUserId(), Comparison.Operator.EQUAL.name(), 0);
        SasQuerySampleDataHelper.doAddSampleConstraintRecord(PermissionsQuery.TYPE, "sas:organization", Comparison.Operator.EQUAL.name(), 0);
        SasQuerySampleDataHelper.doAddSampleOperatorRecord(Condition.Operator.AND);
        SasQuerySampleDataHelper.doAddSampleOrderRecord(PermissionsQuery.PATH, "1", true, 0);
    }

    public static List<SasQueryRecord> createSampleData(QueryService.QueryType type) {
        sampleRecords.clear();
        String typeName = type.name();
        if (typeName.equals("PERMISSIONS")) {
            SasQuerySampleDataHelper.doSetPermissionsSampleData();
        } else if (typeName.startsWith("AUDITENTRY")) {
            SasQuerySampleDataHelper.doSetAuditQuerySampleData(type);
        } else if (typeName.contains("CONTEXTMEMBERSHIP")) {
            SasQuerySampleDataHelper.doSetMembershipQuerySampleData(type);
        } else if (typeName.startsWith("RB")) {
            SasQuerySampleDataHelper.doSetRecycleBinQuerySampleData(type);
        } else {
            SasQuerySampleDataHelper.doSetRepositorySampleData(type);
        }
        return sampleRecords;
    }

    static {
        sampleRecords = new ArrayList<SasQueryRecord>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -60);
        calendar.add(1, -2);
        SAMPLE_DATE_START = SasUtils.toSasDatetimeFormat(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.add(6, -45);
        calendar.add(1, -1);
        SAMPLE_DATE_END = SasUtils.toSasDatetimeFormat(calendar.getTime());
        LOGGEDIN_USER = AuthenticationService.getLoggedInUserId();
    }
}

