/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.query;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.query.SasQueryValidatedRecord;
import com.sas.lsaf.macro.query.SasValidatedQueryData;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Comparison;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.Constraint;
import com.sas.lsaf.query.Order;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SasQueryResult
extends Result {
    private List<SasQueryValidatedRecord> validatedRecords = new ArrayList<SasQueryValidatedRecord>();
    private List<Column> querySelects = new ArrayList<Column>();
    private List<Order> queryOrders = new ArrayList<Order>();
    private List<String> queryConstraints = new ArrayList<String>();
    private String queryLogicalOperator;

    private static List<String> doGetConstraintsAsStrings(HashMap<String, List<Constraint>> queryConstraints) {
        ArrayList<String> constraintStrings = new ArrayList<String>();
        for (String key : queryConstraints.keySet()) {
            List<Constraint> constraintKeys = queryConstraints.get(key);
            ArrayList<String> orList = new ArrayList<String>();
            for (Constraint con : constraintKeys) {
                if (con instanceof Comparison) {
                    orList.add(SasQueryResult.doGetConstraintTextFromComparison((Comparison)con));
                    continue;
                }
                orList.add(SasQueryResult.doGetConstraintTextFromCondition((Condition)con));
            }
            StringBuffer orText = new StringBuffer();
            for (int indx = 0; indx < orList.size(); ++indx) {
                orText.append((String)orList.get(indx) + " ");
                if (indx >= orList.size() - 1) continue;
                orText.append(Condition.Operator.OR.name() + " ");
            }
            constraintStrings.add(orText.toString().trim());
        }
        return constraintStrings;
    }

    private static String doGetConstraintTextFromComparison(Comparison comp) {
        Column column = comp.getColumn();
        Comparison.Operator operator = comp.getOperator();
        Serializable value = comp.getValue();
        boolean isCaseSensitive = comp.isCaseSensitive();
        return SasQueryResult.doGetConstraintText(column, operator, value, isCaseSensitive);
    }

    private static String doGetConstraintTextFromCondition(Condition condition) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        List condConstraints = condition.getConstraints();
        String condOperator = condition.getOperator().name();
        for (int indx = 0; indx < condConstraints.size(); ++indx) {
            Comparison cc = (Comparison)condConstraints.get(indx);
            buffer.append(SasQueryResult.doGetConstraintTextFromComparison(cc));
            if (indx >= condConstraints.size() - 1) continue;
            buffer.append(" " + condOperator + " ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static String doGetConstraintText(Column col, Comparison.Operator operator, Serializable value, boolean isCaseSensitive) {
        Column.Type t;
        Serializable readableValue = value == null ? null : (col.getType().equals((Object)Column.Type.DATE) ? SasUtils.toSasDatetimeFormat(new Date((Long)value)) : value);
        String caseSensitiveText = "";
        if (isCaseSensitive && ((t = col.getType()).equals((Object)Column.Type.ENUM) || t.equals((Object)Column.Type.STRING))) {
            caseSensitiveText = " (case-sensitive)";
        }
        return col.getName() + " " + operator.name() + caseSensitiveText + " " + String.valueOf(readableValue);
    }

    public void setValidatedRecords(List<SasQueryValidatedRecord> records) {
        this.validatedRecords = records;
    }

    public void setQueryFromValidatedData(SasValidatedQueryData validatedQueryData) {
        this.querySelects = validatedQueryData.getQuerySelects();
        this.queryOrders = validatedQueryData.getQueryOrders();
        this.queryConstraints = SasQueryResult.doGetConstraintsAsStrings(validatedQueryData.getQueryConstraints());
        Condition.Operator o = validatedQueryData.getQueryLogicalOperator();
        this.queryLogicalOperator = o == null ? "" : o.name();
    }

    public List<SasQueryValidatedRecord> getValidatedRecords() {
        return this.validatedRecords;
    }

    public int getSize() {
        return this.validatedRecords.size();
    }

    public String getRecordType(double index) {
        return this.validatedRecords.get((int)index).getRecordType();
    }

    public String getColumnClass(double index) {
        return this.validatedRecords.get((int)index).getColumnClass();
    }

    public String getColumnName(double index) {
        return this.validatedRecords.get((int)index).getColumnName();
    }

    public String getValue(double index) {
        return this.validatedRecords.get((int)index).getValue();
    }

    public String getComparator(double index) {
        return this.validatedRecords.get((int)index).getComparator();
    }

    public int getIsCaseSensitive(double index) {
        return this.validatedRecords.get((int)index).getIsCaseSensitive();
    }

    public String getColumnType(double index) {
        return this.validatedRecords.get((int)index).getColumnType();
    }

    public String getNote(double index) {
        return this.validatedRecords.get((int)index).getValidationNote();
    }

    public String getQueryLogicalOperator() {
        return SasUtils.toSasString(this.queryLogicalOperator);
    }

    public int getSelectsSize() {
        return this.querySelects.size();
    }

    public String getSelectColumnClass(double index) {
        return this.querySelects.get((int)index).getQueryClass();
    }

    public String getSelectColumnName(double index) {
        return this.querySelects.get((int)index).getName();
    }

    public String getSelectColumnType(double index) {
        return this.querySelects.get((int)index).getType().name();
    }

    public int getOrdersSize() {
        return this.queryOrders.size();
    }

    public String getOrderColumnClass(double index) {
        return this.queryOrders.get((int)index).getColumn().getQueryClass();
    }

    public String getOrderColumnName(double index) {
        return this.queryOrders.get((int)index).getColumn().getName();
    }

    public String getOrderColumnType(double index) {
        return this.queryOrders.get((int)index).getColumn().getType().name();
    }

    public boolean getOrderIsAscending(double index) {
        return this.queryOrders.get((int)index).isAscending();
    }

    public boolean getOrderIsCaseSensitive(double index) {
        return this.queryOrders.get((int)index).isAscending();
    }

    public int getConstraintsSize() {
        return this.queryConstraints.size();
    }

    public String getConstraint(double index) {
        return this.queryConstraints.get((int)index);
    }
}

