/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.query;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import com.sas.lsaf.macro.query.SasContextQueryException;
import com.sas.lsaf.macro.query.SasQueryColumnsResult;
import com.sas.lsaf.macro.query.SasQueryException;
import com.sas.lsaf.macro.query.SasQueryInvalidRecordsException;
import com.sas.lsaf.macro.query.SasQueryRecord;
import com.sas.lsaf.macro.query.SasQueryRecords;
import com.sas.lsaf.macro.query.SasQueryResult;
import com.sas.lsaf.macro.query.SasQuerySampleDataHelper;
import com.sas.lsaf.macro.query.SasQuerySampleDataResult;
import com.sas.lsaf.macro.query.SasQueryValidationHelper;
import com.sas.lsaf.macro.query.SasValidatedQueryData;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.Constraint;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import com.sas.lsaf.query.Order;
import com.sas.lsaf.query.Query;
import com.sas.lsaf.query.audit.AuditEntryDetailQuery;
import com.sas.lsaf.query.audit.AuditEntryQuery;
import com.sas.lsaf.query.repository.RepositoryContainerQuery;
import com.sas.lsaf.query.repository.RepositoryFileQuery;
import com.sas.lsaf.query.repository.RepositoryFileVersionQuery;
import com.sas.lsaf.query.repository.RepositoryItemQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinContainerQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinFileQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinFileVersionQuery;
import com.sas.lsaf.query.repository.recyclebin.RecycleBinItemQuery;
import com.sas.lsaf.query.security.membership.ContextMembershipQuery;
import com.sas.lsaf.query.security.membership.DistinctContextMembershipQuery;
import com.sas.lsaf.query.security.permissions.PermissionsQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryService {
    private static QueryService FOR_COVERAGE = new QueryService();
    private static final Log LOG = LogFactory.getLog(QueryService.class);

    private static QueryType doValidateQueryType(String value) {
        return (QueryType)ValidationUtils.validateUpcasedEnum(value, "Query type", QueryType.class);
    }

    private static ExtractFileCreateInfo doProcessInputData(SasQueryRecords sasQueryData, SasFileCreateParameters extractData, SasQueryResult result, List<Column> validColumns, Query query, boolean constraintsRequired) {
        ValidationUtils.validateHaveLsafSession();
        SasValidatedQueryData validatedQueryData = QueryService.doGetValidatedQueryData(sasQueryData, result, validColumns, constraintsRequired);
        result.setQueryFromValidatedData(validatedQueryData);
        ExtractFileCreateInfo extractInfo = ContentCreationParametersHelper.toExtractFileCreateInfo(extractData);
        QueryService.doBuildQueryFromValidatedData(query, validatedQueryData);
        result.init(0, "Success.");
        return extractInfo;
    }

    private static SasValidatedQueryData doGetValidatedQueryData(SasQueryRecords sasQueryData, SasQueryResult result, List<Column> validColumns, boolean constraintsRequired) {
        if (sasQueryData.getSize() == 0 && constraintsRequired) {
            throw new SasQueryException("No input data was provided.");
        }
        SasValidatedQueryData validatedQueryData = SasQueryValidationHelper.validateSasQueryData(sasQueryData, validColumns);
        result.setValidatedRecords(validatedQueryData.getValidatedRecords());
        if (validatedQueryData.getInvalidRecordsCount() > 0) {
            throw new SasQueryInvalidRecordsException();
        }
        int cSize = validatedQueryData.getQueryConstraints().size();
        if (cSize == 0 && constraintsRequired) {
            throw new SasQueryException("No constraint records were provided.");
        }
        if (validatedQueryData.getQueryLogicalOperator() == null && cSize > 1) {
            throw new SasQueryException(SasQueryException.NO_LOGICALOPERATOR);
        }
        return validatedQueryData;
    }

    private static void doBuildQueryFromValidatedData(Query query, SasValidatedQueryData validatedQueryData) {
        HashMap<String, List<Constraint>> constraints = validatedQueryData.getQueryConstraints();
        ArrayList<Object> lsafConstraints = new ArrayList<Object>();
        for (String key : constraints.keySet()) {
            List<Constraint> tempConstraints = constraints.get(key);
            if (tempConstraints.size() == 1) {
                lsafConstraints.add(tempConstraints.get(0));
                continue;
            }
            lsafConstraints.add(Condition.or(tempConstraints));
        }
        if (lsafConstraints.size() == 1) {
            query.setConstraint((Constraint)lsafConstraints.get(0));
        } else if (lsafConstraints.size() > 1) {
            query.setConstraint((Constraint)new Condition(validatedQueryData.getQueryLogicalOperator(), lsafConstraints));
        }
        List<Order> orders = validatedQueryData.getQueryOrders();
        if (!orders.isEmpty()) {
            query.setOrder(orders);
        }
        query.select(validatedQueryData.getQuerySelects());
    }

    private static ContextMembershipQuery.MembershipScope doValidateContextQueryParameters(String contextPath, String scope) {
        try {
            ValidationUtils.validateRequiredParameter(contextPath, "Context path");
            if (ValidationUtils.valueIsMissing((Serializable)((Object)scope))) {
                return ContextMembershipQuery.MembershipScope.ALL;
            }
            return (ContextMembershipQuery.MembershipScope)ValidationUtils.validateUpcasedEnum(scope, "Membership Scope", ContextMembershipQuery.MembershipScope.class);
        }
        catch (Exception ex) {
            throw new SasContextQueryException(ex.getLocalizedMessage());
        }
    }

    public static String executeAuditEntryQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Audit Entry Query from data set");
        }
        try {
            AuditEntryQuery query = new AuditEntryQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, AuditEntryQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiAuditQueryService().executeAuditEntryQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeAuditEntryDetailQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Audit Entry Detail Query from data set");
        }
        try {
            AuditEntryDetailQuery query = new AuditEntryDetailQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, AuditEntryDetailQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiAuditQueryService().executeAuditEntryDetailQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeContextMembershipQuery(String path, String scope, SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Context Membership Query from data set");
        }
        try {
            ContextMembershipQuery.MembershipScope membershipScope = QueryService.doValidateContextQueryParameters(path, scope);
            ContextMembershipQuery query = new ContextMembershipQuery(path, membershipScope);
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, ContextMembershipQuery.ALL, (Query)query, false);
            return ServiceManagerFactory.getApiContextMembershipService().executeContextMembershipQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeDistinctContextMembershipQuery(String path, String scope, SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Distinct Context Membership Query from data set");
        }
        try {
            ContextMembershipQuery.MembershipScope membershipScope = QueryService.doValidateContextQueryParameters(path, scope);
            DistinctContextMembershipQuery query = new DistinctContextMembershipQuery(path, membershipScope);
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, DistinctContextMembershipQuery.ALL, (Query)query, false);
            return ServiceManagerFactory.getApiContextMembershipService().executeDistinctContextMembershipQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRepositoryItemQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Repository Item Query from data set");
        }
        try {
            RepositoryItemQuery query = new RepositoryItemQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RepositoryItemQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRepositoryQueryService().executeRepositoryItemQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRepositoryContainerQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Repository Container Query from data set");
        }
        try {
            RepositoryContainerQuery query = new RepositoryContainerQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RepositoryContainerQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRepositoryQueryService().executeRepositoryContainerQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRepositoryFileQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Repository File Query from data set");
        }
        try {
            RepositoryFileQuery query = new RepositoryFileQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RepositoryFileQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRepositoryQueryService().executeRepositoryFileQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRepositoryFileVersionQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Repository File Version Query from data set");
        }
        try {
            RepositoryFileVersionQuery query = new RepositoryFileVersionQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RepositoryFileVersionQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRepositoryQueryService().executeRepositoryFileVersionQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRecycleBinItemQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Recycle Bin Item Query from data set");
        }
        try {
            RecycleBinItemQuery query = new RecycleBinItemQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RecycleBinItemQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRecycleBinQueryService().executeRecycleBinItemQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRecycleBinContainerQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Recycle Bin Container Query from data set");
        }
        try {
            RecycleBinContainerQuery query = new RecycleBinContainerQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RecycleBinContainerQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRecycleBinQueryService().executeRecycleBinContainerQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRecycleBinFileQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Recycle Bin File Query from data set");
        }
        try {
            RecycleBinFileQuery query = new RecycleBinFileQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RecycleBinFileQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRecycleBinQueryService().executeRecycleBinFileQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeRecycleBinFileVersionQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Recycle Bin File Version Query from data set");
        }
        try {
            RecycleBinFileVersionQuery query = new RecycleBinFileVersionQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, RecycleBinFileVersionQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiRecycleBinQueryService().executeRecycleBinFileVersionQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeCurrentPermissionsQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Current Permission Query from data set");
        }
        try {
            PermissionsQuery query = new PermissionsQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, PermissionsQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiPermissionsQueryService().executeCurrentPermissionsQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String executeDefaultPermissionsQuery(SasQueryRecords sasQueryData, SasFileCreateParameters exportData, SasQueryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing Default Permission Query from data set");
        }
        try {
            PermissionsQuery query = new PermissionsQuery();
            ExtractFileCreateInfo extractInfo = QueryService.doProcessInputData(sasQueryData, exportData, result, PermissionsQuery.ALL, (Query)query, true);
            return ServiceManagerFactory.getApiPermissionsQueryService().executeDefaultPermissionsQuery(query, extractInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getQueryColumns(String queryType, SasQueryColumnsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting columns for query type " + queryType));
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            QueryType aType = QueryService.doValidateQueryType(queryType);
            switch (aType.ordinal()) {
                case 1: {
                    result.setColumns(aType.name(), AuditEntryQuery.ALL);
                    break;
                }
                case 2: {
                    result.setColumns(aType.name(), AuditEntryDetailQuery.ALL);
                    break;
                }
                case 3: {
                    result.setColumns(aType.name(), ContextMembershipQuery.ALL);
                    break;
                }
                case 4: {
                    result.setColumns(aType.name(), DistinctContextMembershipQuery.ALL);
                    break;
                }
                case 5: {
                    result.setColumns(aType.name(), RepositoryItemQuery.ALL);
                    break;
                }
                case 6: {
                    result.setColumns(aType.name(), RepositoryFileQuery.ALL);
                    break;
                }
                case 7: {
                    result.setColumns(aType.name(), RepositoryFileVersionQuery.ALL);
                    break;
                }
                case 8: {
                    result.setColumns(aType.name(), RepositoryContainerQuery.ALL);
                    break;
                }
                case 9: {
                    result.setColumns(aType.name(), RecycleBinItemQuery.ALL);
                    break;
                }
                case 10: {
                    result.setColumns(aType.name(), RecycleBinFileQuery.ALL);
                    break;
                }
                case 11: {
                    result.setColumns(aType.name(), RecycleBinFileVersionQuery.ALL);
                    break;
                }
                case 12: {
                    result.setColumns(aType.name(), RecycleBinContainerQuery.ALL);
                    break;
                }
                case 0: {
                    result.setColumns(aType.name(), PermissionsQuery.ALL);
                    break;
                }
                default: {
                    throw new SasQueryException("Unknown query type encountered: " + queryType);
                }
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getSampleQueryDataset(String queryType, SasQuerySampleDataResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting sample data for query type " + queryType));
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            QueryType type = QueryService.doValidateQueryType(queryType);
            ArrayList<SasQueryRecord> sampleRecords = new ArrayList<SasQueryRecord>();
            sampleRecords.addAll(SasQuerySampleDataHelper.createSampleData(type));
            result.setSampleRecords(sampleRecords);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static enum QueryType {
        PERMISSIONS,
        AUDITENTRYQUERY,
        AUDITENTRYDETAILQUERY,
        CONTEXTMEMBERSHIP,
        DISTINCTCONTEXTMEMBERSHIP,
        ITEM,
        FILE,
        FILEVERSION,
        CONTAINER,
        RBITEM,
        RBFILE,
        RBFILEVERSION,
        RBCONTAINER;

    }
}

