/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.messaging.subscription;

import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.messaging.subscription.SasSubscriptionsResult;
import com.sas.lsaf.messaging.subscription.SubscriptionEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SubscriptionService {
    private static Log LOG = LogFactory.getLog(SubscriptionService.class);
    private static SubscriptionService FOR_COVERAGE = new SubscriptionService();

    private SubscriptionService() {
    }

    private static com.sas.lsaf.messaging.subscription.SubscriptionService doGetService() {
        return ServiceManagerFactory.getApiSubscriptionService();
    }

    public static void getSubscriptionsForCurrentUser(String path, SasSubscriptionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting subscriptions for current user. Path: " + path));
        }
        try {
            Set subscriptions = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? SubscriptionService.doGetService().getSubscriptions() : SubscriptionService.doGetService().getSubscriptionsByPath(path);
            result.setSubscriptions(subscriptions);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setSubscriptions(String path, String events, SasSubscriptionsResult result) {
        try {
            ValidationUtils.assertRequiredPath(path);
            HashSet<SubscriptionEvent> apiEvents = new HashSet<SubscriptionEvent>();
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)events))) {
                String[] commaSeparatedArr;
                for (String event : commaSeparatedArr = SasUtils.getArrayFromSasCommaDelimitedString(events)) {
                    SubscriptionEvent se = (SubscriptionEvent)ValidationUtils.validateNotRequiredEnum(event, "Subscription event", SubscriptionEvent.class, true);
                    if (se == null) continue;
                    apiEvents.add(se);
                }
            }
            Set subscriptions = SubscriptionService.doGetService().setSubscriptions(path, apiEvents);
            result.setSubscriptions(subscriptions);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

