/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.session;

import com.sas.lsaf.execution.session.EngineType;
import com.sas.lsaf.execution.session.Session;
import com.sas.lsaf.execution.session.SessionQuery;
import com.sas.lsaf.execution.session.SessionSearchResults;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.session.SasSessionsResult;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionService {
    private static Log LOG = LogFactory.getLog(SessionService.class);
    private static SessionService FOR_COVERAGE = new SessionService();

    private SessionService() {
    }

    private static com.sas.lsaf.execution.session.SessionService doGetService() {
        return ServiceManagerFactory.getApiSessionService();
    }

    private static EngineType doValidateEngineType(String engineType) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)engineType))) {
            return EngineType.SAS;
        }
        return (EngineType)ValidationUtils.validateNotRequiredEnum(engineType, "Engine type", EngineType.class, true);
    }

    private static String doGetSizeAsString(String formatted, long value) {
        boolean formatIt = ValidationUtils.validateBinaryFlagDefaultFalse(formatted, "Format size value");
        return formatIt ? SasUtils.toSasFormattedFileSize(value) : SasUtils.toSasString((float)value);
    }

    public static boolean search(String userId, String engine, String type, String state, String submissionLabel, String startedFromDate, String startedToDate, String endedFromDate, String endedToDate, String limit, SasSessionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting sessions by query");
        }
        try {
            SessionQuery query = new SessionQuery();
            query.setUserId(ValidationUtils.toJavaString(userId));
            Session.SessionEngine e = ValidationUtils.valueIsMissing((Serializable)((Object)engine)) ? null : (Session.SessionEngine)ValidationUtils.validateNotRequiredEnum(engine, "Session engine", Session.SessionEngine.class, true);
            query.setEngine(e);
            Session.SessionType sType = ValidationUtils.valueIsMissing((Serializable)((Object)type)) ? null : (Session.SessionType)ValidationUtils.validateNotRequiredEnum(type, "Session type", Session.SessionType.class, true);
            query.setType(sType);
            Session.SessionState ss = ValidationUtils.valueIsMissing((Serializable)((Object)state)) ? null : (Session.SessionState)ValidationUtils.validateNotRequiredEnum(state, "Session state", Session.SessionState.class, true);
            query.setState(ss);
            query.setSubmissionLabel(ValidationUtils.toJavaString(submissionLabel));
            query.setFromDateStarted(ValidationUtils.validateDateString("From started", startedFromDate));
            query.setToDateStarted(ValidationUtils.validateDateString("To started", startedToDate));
            query.setFromDateEnded(ValidationUtils.validateDateString("From ended", endedFromDate));
            query.setToDateEnded(ValidationUtils.validateDateString("To ended", endedToDate));
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)limit))) {
                query.setLimit(ValidationUtils.validateIntegerValue("Limit", limit));
            }
            SessionSearchResults ssr = SessionService.doGetService().search(query);
            result.setSessions(ssr.getSessions());
            result.init(0, "Success.");
            return ssr.isLimitReached();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    public static boolean sessionExists(String sessionId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session exists " + sessionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            SessionService.doGetService().getSession(sessionId);
            result.init(0, "Success.");
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void deleteSession(String sessionId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting session " + sessionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            SessionService.doGetService().deleteSession(sessionId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String endSession(String sessionId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ending session " + sessionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            Session ss = SessionService.doGetService().endSession(sessionId);
            result.init(0, "Success.");
            return ss.getState().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getSessionState(String sessionId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting state for session " + sessionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            Session ss = SessionService.doGetService().getSession(sessionId);
            result.init(0, "Success.");
            return ss.getState().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getSessionLogSize(String sessionId, String formatSize, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting log size for session " + sessionId + ", formatSize = " + formatSize));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            result.init(0, "Success.");
            return SessionService.doGetSizeAsString(formatSize, SessionService.doGetService().getLogFileSize(sessionId));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getSessionListSize(String sessionId, String formatSize, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting list size for session " + sessionId + ", formatSize = " + formatSize));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            result.init(0, "Success.");
            return SessionService.doGetSizeAsString(formatSize, SessionService.doGetService().getResultsFileSize(sessionId));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void saveSessionLog(String logPath, String sessionId, String engine, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving log for session " + sessionId + ", engine = " + engine));
        }
        try {
            ValidationUtils.assertRequiredPath(logPath);
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            EngineType et = SessionService.doValidateEngineType(engine);
            SessionService.doGetService().saveLogFileForEngineToCurrentUserWorkspace(sessionId, et, logPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void saveSessionResults(String resultsPath, String sessionId, String engine, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving results for session " + sessionId + ", engine = " + engine));
        }
        try {
            ValidationUtils.assertRequiredPath(resultsPath);
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            EngineType et = SessionService.doValidateEngineType(engine);
            SessionService.doGetService().saveResultsFileForEngineToCurrentUserWorkspace(sessionId, et, resultsPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

