/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.schedule;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.ValidatedSubmittableJob;
import com.sas.lsaf.macro.execution.job.JobUtils;
import com.sas.lsaf.macro.execution.schedule.SasSchedulableJob;
import com.sas.lsaf.macro.execution.schedule.SasSchedule;
import com.sas.lsaf.macro.execution.schedule.SasScheduleParametersResult;
import com.sas.lsaf.macro.execution.schedule.SasSchedulePropertiesResult;
import com.sas.lsaf.macro.execution.schedule.SasSchedulesResult;
import com.sas.lsaf.schedule.Schedulable;
import com.sas.lsaf.schedule.Schedule;
import com.sas.lsaf.schedule.ScheduleException;
import com.sas.lsaf.schedule.ScheduleJobInfo;
import com.sas.lsaf.schedule.ScheduleNotFoundException;
import com.sas.lsaf.schedule.ScheduleTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScheduleService {
    private static Log LOG = LogFactory.getLog(ScheduleService.class);
    private static ScheduleService FOR_COVERAGE = new ScheduleService();

    private ScheduleService() {
    }

    private static com.sas.lsaf.schedule.ScheduleService doGetService() {
        return ServiceManagerFactory.getApiScheduleService();
    }

    private static Schedule doGetSchedule(String scheduleId) throws ScheduleException, ScheduleNotFoundException {
        ValidationUtils.validateRequiredParameter(scheduleId, "Schedule id");
        return ScheduleService.doGetService().getSchedule(scheduleId);
    }

    private static final List<SasProperty> doConvertScheduleToProperties(Schedule schedule) {
        ArrayList<SasProperty> sps = new ArrayList<SasProperty>();
        sps.add(new SasProperty("scheduleId", schedule.getId()));
        sps.add(new SasProperty("name", schedule.getName()));
        sps.add(new SasProperty("description", schedule.getDescription()));
        sps.add(new SasProperty("owner", schedule.getOwner()));
        sps.add(new SasProperty("status", schedule.getStatus().name()));
        sps.add(new SasProperty("lastModified", SasUtils.toSasPropertyString(AttributeDefinition.AttributeType.DATE.name(), SasUtils.toSasString(schedule.getLastModified()))));
        ScheduleJobInfo job = (ScheduleJobInfo)schedule.getSchedulable();
        sps.add(new SasProperty("jobLocation", job.getSourceLocation().name()));
        sps.add(new SasProperty("jobPath", job.getPath()));
        sps.add(new SasProperty("jobVersion", job.getVersion()));
        ScheduleTrigger st = schedule.getTrigger();
        sps.add(new SasProperty("triggerType", st.getTriggerType().name()));
        sps.add(new SasProperty("triggerStartDate", SasUtils.toSasPropertyString(AttributeDefinition.AttributeType.DATE.name(), SasUtils.toSasString(st.getStartDate()))));
        sps.add(new SasProperty("triggerInterval", SasUtils.toSasString(st.getInterval())));
        sps.add(new SasProperty("triggerEndDate", SasUtils.toSasPropertyString(AttributeDefinition.AttributeType.DATE.name(), SasUtils.toSasString(st.getEndDate()))));
        sps.add(new SasProperty("triggerOccurrences", SasUtils.toSasString(st.getNumOccurrences())));
        sps.add(new SasProperty("triggerRepeatForever", SasUtils.toSasString(st.getRepeatForever())));
        Set dwSet = st.getDaysOfWeek();
        String daysString = "";
        if (dwSet != null) {
            ArrayList dwList = new ArrayList(dwSet);
            Collections.sort(dwList);
            daysString = SasUtils.toSasCommaDelimitedString(dwList);
        }
        sps.add(new SasProperty("triggerWeekdays", daysString));
        return sps;
    }

    private static String doCreateNewSchedule(ScheduleTrigger.TriggerType triggerType, SasSchedule sasSchedule, SasSchedulableJob sasJob) throws Exception {
        ValidatedSubmittableJob vj = JobUtils.getValidatedSchedulableJob(sasJob);
        Job job = new Job(vj.getPath(), vj.getVersion());
        job.setSourceLocation(vj.getSourceLocation());
        ScheduleJobInfo jobInfo = new ScheduleJobInfo(job, vj.getParameterValues());
        sasSchedule.setTriggerType(triggerType);
        ScheduleTrigger trigger = sasSchedule.toScheduleTrigger();
        Schedule newSched = ScheduleService.doGetService().createSchedule(sasSchedule.getName(), sasSchedule.getDescription(), (Schedulable)jobInfo, trigger);
        return newSched.getId();
    }

    public static String createOneTimeSchedule(SasSchedule sasSchedule, SasSchedulableJob jobInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create one-time schedule: " + sasSchedule.getName()));
        }
        try {
            result.init(0, "Success.");
            return ScheduleService.doCreateNewSchedule(ScheduleTrigger.TriggerType.ONCE, sasSchedule, jobInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String createIntervalSchedule(SasSchedule sasSchedule, SasSchedulableJob jobInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create interval schedule: " + sasSchedule.getName()));
        }
        try {
            ScheduleIntervalType sit = (ScheduleIntervalType)ValidationUtils.validateUpcasedEnum(sasSchedule.getIntervalType(), "Schedule interval type", ScheduleIntervalType.class);
            ScheduleTrigger.TriggerType tt = ScheduleTrigger.TriggerType.valueOf((String)sit.name().trim().toUpperCase());
            result.init(0, "Success.");
            return ScheduleService.doCreateNewSchedule(tt, sasSchedule, jobInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String createWeeklySchedule(SasSchedule sasSchedule, SasSchedulableJob jobInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create weekly schedule: " + sasSchedule.getName()));
        }
        try {
            result.init(0, "Success.");
            return ScheduleService.doCreateNewSchedule(ScheduleTrigger.TriggerType.WEEKLY, sasSchedule, jobInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getAllSchedules(SasSchedulesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting all schedules");
        }
        try {
            Set scheds = ScheduleService.doGetService().getAllSchedules();
            result.setSchedules(scheds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getMySchedules(SasSchedulesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting schedules for current user");
        }
        try {
            Set scheds = ScheduleService.doGetService().getCurrentUserSchedules();
            result.setSchedules(scheds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean scheduleExistsByName(String scheduleName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if schedule exists by name: " + scheduleName));
        }
        try {
            ValidationUtils.validateRequiredParameter(scheduleName, "Schedule name");
            boolean exists = ScheduleService.doGetService().scheduleExists(scheduleName);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean scheduleExistsById(String scheduleId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if schedule exists by id: " + scheduleId));
        }
        try {
            ScheduleService.doGetSchedule(scheduleId);
            result.init(0, "Success.");
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void deleteSchedule(String scheduleId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting schedule " + scheduleId));
        }
        try {
            ValidationUtils.validateRequiredParameter(scheduleId, "Schedule id");
            ScheduleService.doGetService().deleteSchedule(scheduleId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void pauseSchedule(String scheduleId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Pausing schedule " + scheduleId));
        }
        try {
            ValidationUtils.validateRequiredParameter(scheduleId, "Schedule id");
            ScheduleService.doGetService().pauseSchedule(scheduleId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void resumeSchedule(String scheduleId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resuming schedule " + scheduleId));
        }
        try {
            ValidationUtils.validateRequiredParameter(scheduleId, "Schedule id");
            ScheduleService.doGetService().resumeSchedule(scheduleId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getScheduleStatus(String scheduleId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting status for schedule: " + scheduleId));
        }
        try {
            Schedule sched = ScheduleService.doGetSchedule(scheduleId);
            result.init(0, "Success.");
            return sched.getStatus().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getScheduleProperties(String scheduleId, SasSchedulePropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting properties for schedule: " + scheduleId));
        }
        try {
            Schedule sched = ScheduleService.doGetSchedule(scheduleId);
            List<SasProperty> properties = ScheduleService.doConvertScheduleToProperties(sched);
            result.setScheduleProperties(scheduleId, sched.getName(), properties);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getScheduleJobParameters(String scheduleId, SasScheduleParametersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job parameters for schedule: " + scheduleId));
        }
        try {
            Schedule sched = ScheduleService.doGetSchedule(scheduleId);
            ScheduleJobInfo sji = (ScheduleJobInfo)sched.getSchedulable();
            result.setScheduleParameters(sched.getId(), sched.getName(), sji);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isJobScheduled(String jobSourceLocation, String jobPath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determining if " + jobSourceLocation + " job is scheduled: " + jobPath));
        }
        try {
            ValidationUtils.assertRequiredPath(jobPath);
            SourceLocation srcLoc = ValidationUtils.validateSourceLocation(jobSourceLocation);
            boolean isScheduled = false;
            isScheduled = SourceLocation.REPOSITORY.equals((Object)srcLoc) ? ScheduleService.doGetService().isRepositoryJobScheduled(jobPath) : ScheduleService.doGetService().isWorkspaceJobScheduled(jobPath);
            result.init(0, "Success.");
            return isScheduled;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static enum ScheduleIntervalType {
        MINUTELY,
        HOURLY,
        DAILY;

    }

    public static enum ScheduleEndType {
        NONE,
        DATE,
        OCCURRENCES;

    }
}

