/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.schedule;

import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.schedule.SasScheduleException;
import com.sas.lsaf.macro.execution.schedule.ScheduleService;
import com.sas.lsaf.schedule.ScheduleTrigger;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;

public class SasSchedule {
    private String name;
    private String description;
    private String startDate;
    private ScheduleTrigger.TriggerType triggerType = ScheduleTrigger.TriggerType.ONCE;
    private String intervalType;
    private String interval;
    private String daysofweek;
    private String endType;
    private String endValue;

    public SasSchedule(String name, String description, String startdate) {
        this.name = name;
        this.description = description;
        this.startDate = startdate;
    }

    public SasSchedule(String name, String description, String startdate, String intervaltype, String interval, String endType, String endValue) {
        this.name = name;
        this.description = description;
        this.startDate = startdate;
        this.intervalType = intervaltype;
        this.interval = interval;
        this.endType = endType;
        this.endValue = endValue;
    }

    public SasSchedule(String name, String description, String startdate, String endType, String endValue, String daysofweek) {
        this.name = name;
        this.description = description;
        this.startDate = startdate;
        this.endType = endType;
        this.endValue = endValue;
        this.daysofweek = daysofweek;
    }

    public ScheduleTrigger.TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(ScheduleTrigger.TriggerType type) {
        this.triggerType = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStartdate() {
        return this.startDate;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getDaysOfWeek() {
        return this.daysofweek;
    }

    public String getEndType() {
        return this.endType;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public ScheduleTrigger toScheduleTrigger() {
        ValidationUtils.validateRequiredParameter(this.name, "Schedule name");
        ScheduleTrigger trigger = new ScheduleTrigger();
        trigger.setTriggerType(this.triggerType);
        Date start = ValidationUtils.validateRequiredDateString("Start date", this.startDate);
        trigger.setStartDate(start);
        if (this.triggerType.equals((Object)ScheduleTrigger.TriggerType.ONCE)) {
            return trigger;
        }
        switch (this.triggerType) {
            case ONCE: {
                return trigger;
            }
            case WEEKLY: {
                if (ValidationUtils.valueIsMissing((Serializable)((Object)this.daysofweek))) {
                    throw new SasScheduleException("At least one weekday value must be specified.");
                }
                String[] wDays = SasUtils.getArrayFromSasCommaDelimitedString(this.daysofweek);
                HashSet<ScheduleTrigger.DayOfWeek> days = new HashSet<ScheduleTrigger.DayOfWeek>();
                for (String day : wDays) {
                    ScheduleTrigger.DayOfWeek dow = (ScheduleTrigger.DayOfWeek)ValidationUtils.validateUpcasedEnum(day, "Schedule weekday value", ScheduleTrigger.DayOfWeek.class);
                    days.add(dow);
                }
                trigger.setDaysOfWeek(days);
                break;
            }
            default: {
                ScheduleService.ScheduleIntervalType sit = (ScheduleService.ScheduleIntervalType)ValidationUtils.validateUpcasedEnum(this.intervalType, "Schedule interval type", ScheduleService.ScheduleIntervalType.class);
                trigger.setTriggerType(ScheduleTrigger.TriggerType.valueOf((String)sit.name().trim().toUpperCase()));
                try {
                    int validatedInt = ValidationUtils.validateRequiredIntegerValue("Schedule interval", this.interval);
                    if (validatedInt < 1) {
                        throw new Exception();
                    }
                    trigger.setInterval(validatedInt);
                    break;
                }
                catch (Exception e) {
                    throw new SasScheduleException("Interval value must be a specified as a valid integer greater than 0.");
                }
            }
        }
        ScheduleService.ScheduleEndType eType = (ScheduleService.ScheduleEndType)ValidationUtils.validateUpcasedEnum(this.endType, "Schedule end type", ScheduleService.ScheduleEndType.class);
        switch (eType) {
            case OCCURRENCES: {
                try {
                    int numOcc = ValidationUtils.validateRequiredIntegerValue("Schedule occurences", this.endValue);
                    trigger.setNumOccurrences(numOcc);
                    break;
                }
                catch (Exception e) {
                    throw new SasScheduleException("End value must be a valid integer when end type is OCCURRENCES.");
                }
            }
            case DATE: {
                try {
                    trigger.setEndDate(ValidationUtils.validateRequiredDateString("Schedule end value", this.endValue));
                    break;
                }
                catch (Exception e) {
                    throw new SasScheduleException("End value must be a valid date when end type is DATE. Dates must be in SAS datetime20. or E8601DZ25. format (e.g., 05NOV2012:09:23:12 or 2012-11-05T09:23:12-04:00).");
                }
            }
            default: {
                trigger.setRepeatForever(true);
            }
        }
        return trigger;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SasSchedule [");
        buf.append("Name: " + this.getName());
        buf.append(", Description: " + this.getDescription());
        buf.append(", StartDate: " + this.getStartdate());
        buf.append(", IntervalType: " + this.getIntervalType());
        buf.append(", Interval: " + this.getInterval());
        buf.append(", DaysOfWeek: " + this.getDaysOfWeek());
        buf.append(", EndType: " + this.getEndType());
        buf.append(", EndValue: " + this.getEndValue());
        return buf.toString();
    }
}

