/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobsubmission;

import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.macro.common.result.Result;

public class SasJobSubmissionStatusResult
extends Result {
    private JobSubmissionStatus jobStatus;

    public void setStatus(JobSubmissionStatus apiJobStatus) {
        this.jobStatus = apiJobStatus;
    }

    public String getLogMsgLevel() {
        String status = this.getStatus();
        if (status.contains("COMPLETED")) {
            if (status.contains("ERROR") || status.contains("FAILED")) {
                return MessageLevel.ERROR.name();
            }
            if (status.contains("WARNING")) {
                return MessageLevel.WARNING.name();
            }
        }
        return MessageLevel.NOTE.name();
    }

    public String getStatus() {
        if (this.jobStatus == null) {
            return "";
        }
        String status = this.jobStatus.getDetailStatus().name();
        return status == null ? "" : status;
    }

    public String getStatusMessage() {
        if (this.jobStatus == null) {
            return "";
        }
        String statusMsg = this.jobStatus.getStatusMessage();
        return statusMsg == null ? "" : statusMsg;
    }

    public static enum MessageLevel {
        NOTE,
        WARNING,
        ERROR;

    }
}

