/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobsubmission;

import com.sas.lsaf.execution.job.JobSubmission;
import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasPropertiesResult;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.ValidatedSubmittableJob;
import com.sas.lsaf.macro.execution.job.JobUtils;
import com.sas.lsaf.macro.execution.jobsubmission.SasJobSubmissionStatusResult;
import com.sas.lsaf.macro.execution.jobsubmission.SasJobSubmissionsResult;
import com.sas.lsaf.macro.execution.jobsubmission.SasSubmittableJob;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JobSubmissionService {
    private static Log LOG = LogFactory.getLog(JobSubmissionService.class);
    private static JobSubmissionService FOR_COVERAGE = new JobSubmissionService();

    private JobSubmissionService() {
    }

    private static com.sas.lsaf.execution.job.JobSubmissionService doGetService() {
        return ServiceManagerFactory.getApiJobSubmissionService();
    }

    public static void getJobSubmissionBySessionId(String sessionId, SasPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Job Submission by session Id: " + sessionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sessionId, "SAS Session id");
            JobSubmission js = JobSubmissionService.doGetService().getJobSubmissionBySession(sessionId);
            result.addProperty("submissionId", js.getId());
            result.addProperty("jobId", js.getJobId());
            result.addProperty("jobPath", js.getJobPath());
            result.addProperty("jobVersion", js.getJobVersion());
            result.addProperty("sessionId", js.getSessionId());
            result.addProperty("submissionType", js.getSubmissionType().name());
            result.addProperty("submissionSummaryStatus", js.getJobSubmissionStatus().getSummaryStatus().name());
            result.addProperty("submissionDetailStatus", js.getJobSubmissionStatus().getDetailStatus().name());
            result.addProperty("submissionStatusMessage", js.getJobSubmissionStatus().getStatusMessage());
            result.addProperty("submittedBy", js.getSubmittedBy());
            result.addProperty("submitted", SasUtils.toSasString(js.getSubmitted()));
            result.addProperty("completed", SasUtils.toSasString(js.getCompleted()));
            result.addProperty("jobOwner", js.getJobOwner());
            result.addProperty("runAsUser", js.getRunAsUser());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String submitWorkspaceJob(SasSubmittableJob job, String runAsTest, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting workspace job (as test=" + runAsTest + "): " + job.getPath()));
        }
        try {
            ValidatedSubmittableJob vj = JobUtils.getValidatedSubmittableJob(job);
            boolean testingJob = ValidationUtils.validateBinaryFlagDefaultFalse(runAsTest, "Run as test");
            JobSubmission js = null;
            js = testingJob ? JobSubmissionService.doGetService().submitTestJob(vj.getPath(), vj.getParameterValues()) : JobSubmissionService.doGetService().submitWorkspaceJob(vj.getPath(), vj.getParameterValues());
            result.init(0, "Success.");
            return js == null ? "" : js.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String runAndPopulate(SasSubmittableJob job, String useRelativePaths, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting workspace job and populate the inputs and outputs " + job.getPath()));
        }
        try {
            ValidatedSubmittableJob vj = JobUtils.getValidatedSubmittableJob(job);
            boolean urp = ValidationUtils.validateBinaryFlagDefaultFalse(useRelativePaths, "Use relative path");
            JobSubmission js = JobSubmissionService.doGetService().submitAndPopulateWorkspaceJob(vj.getPath(), vj.getParameterValues(), urp);
            result.init(0, "Success.");
            return js.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String submitRepositoryJob(SasSubmittableJob job, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting repository job " + job.getPath() + ", version " + job.getVersion()));
        }
        try {
            ValidatedSubmittableJob vj = JobUtils.getValidatedSubmittableJob(job);
            JobSubmission js = JobSubmissionService.doGetService().submitRepositoryJob(vj.getPath(), vj.getVersion(), vj.getParameterValues());
            result.init(0, "Success.");
            return js.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getJobSubmissionStatus(String submissionId, SasJobSubmissionStatusResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job submission status for job submission id " + submissionId));
        }
        try {
            ValidationUtils.validateRequiredParameter(submissionId, "Job submission id");
            JobSubmissionStatus jobStatus = JobSubmissionService.doGetService().getJobSubmissionStatus(submissionId);
            if (jobStatus == null || jobStatus.getDetailStatus() == null) {
                throw new ResultException(-1, "Unable to determine job submission status for submission id: " + submissionId);
            }
            result.setStatus(jobStatus);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobSubmissionHistory(String path, SasJobSubmissionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job submission history for job " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            List history = JobSubmissionService.doGetService().getJobSubmissionsByJobPath(path);
            result.setSubmissions(history);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

