/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobmanifest;

import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestMetrics;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestMetric;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestResult;
import java.util.ArrayList;
import java.util.List;

public class SasManifestMetricsResult
extends SasManifestResult {
    private List<SasManifestMetric> metrics = new ArrayList<SasManifestMetric>();

    private static List<SasManifestMetric> doGetSasManifestMetrics(Manifest jobManifest) {
        ArrayList<SasManifestMetric> metrics = new ArrayList<SasManifestMetric>();
        ManifestMetrics mm = jobManifest.getManifestMetrics();
        if (mm == null) {
            metrics.add(new SasManifestMetric("Job"));
            metrics.add(new SasManifestMetric("Programs"));
            metrics.add(new SasManifestMetric("Inputs"));
            metrics.add(new SasManifestMetric("Inputs_Referenced"));
            metrics.add(new SasManifestMetric("Total_Inputs"));
            metrics.add(new SasManifestMetric("Outputs"));
        } else {
            metrics.add(new SasManifestMetric("Job", mm.getJobMetrics()));
            metrics.add(new SasManifestMetric("Programs", mm.getProgramMetrics()));
            metrics.add(new SasManifestMetric("Inputs", mm.getInputsMetrics()));
            metrics.add(new SasManifestMetric("Inputs_Referenced", mm.getInputsReferencedMetrics()));
            metrics.add(new SasManifestMetric("Total_Inputs", mm.getTotalInputMetrics()));
            metrics.add(new SasManifestMetric("Outputs", mm.getOutputsMetrics()));
            metrics.add(new SasManifestMetric("Outputs_Referenced", mm.getOutputsReferencedMetrics()));
        }
        SasManifestMetric execTime = new SasManifestMetric("Total_Execution_Time");
        Long totExecTime = jobManifest.getTotalExecutionTime();
        if (totExecTime != null) {
            execTime.setTime(totExecTime);
        }
        metrics.add(execTime);
        return metrics;
    }

    public void setMetrics(Manifest manifest) {
        this.setManifest(manifest);
        this.metrics = SasManifestMetricsResult.doGetSasManifestMetrics(manifest);
    }

    public List<SasManifestMetric> getList() {
        return this.metrics;
    }

    public int getSize() {
        return this.metrics.size();
    }

    public SasManifestMetric getMetric(double index) {
        return this.metrics.get((int)index);
    }

    public String getMetricType(double index) {
        return this.getMetric(index).getType();
    }

    public int getMetricTotal(double index) {
        return this.getMetric(index).getTotal();
    }

    public long getMetricSize(double index) {
        return this.getMetric(index).getSize();
    }

    public String getMetricFormattedSize(double index) {
        return this.getMetric(index).getFormattedSize();
    }

    public long getMetricTime(double index) {
        return this.getMetric(index).getTime();
    }

    public String getMetricFormattedTime(double index) {
        return this.getMetric(index).getFormattedTime();
    }
}

