/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobmanifest;

import com.sas.lsaf.execution.job.ManifestSynchronizationMetrics;
import com.sas.lsaf.macro.common.utils.SasUtils;

public class SasManifestMetric {
    public static int NO_VALUE_INT = -99;
    public static long NO_VALUE_LONG = Long.MIN_VALUE;
    private String type;
    private int total;
    private long size;
    private long time;

    public SasManifestMetric(String type, ManifestSynchronizationMetrics metric) {
        this.type = type;
        if (metric == null) {
            this.doSetMetricNotFoundValues();
        } else {
            this.total = metric.getTotal();
            this.size = metric.getSize();
            this.time = metric.getTime();
        }
    }

    public SasManifestMetric(String type) {
        this.type = type;
        this.doSetMetricNotFoundValues();
    }

    private void doSetMetricNotFoundValues() {
        this.total = NO_VALUE_INT;
        this.size = NO_VALUE_LONG;
        this.time = NO_VALUE_LONG;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int t) {
        this.total = t;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(long s) {
        this.size = s;
    }

    public String getFormattedSize() {
        Long s = this.getSize();
        if (s == NO_VALUE_LONG) {
            return "";
        }
        return SasUtils.toSasFormattedFileSize(s);
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(long t) {
        this.time = t;
    }

    public String getFormattedTime() {
        Long t = this.getTime();
        if (t == NO_VALUE_LONG) {
            return "";
        }
        return SasUtils.toSasFormattedDuration(t);
    }
}

