/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobmanifest;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestFileRef;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.execution.jobmanifest.JobManifestService;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestResult;
import java.util.ArrayList;
import java.util.List;

public class SasManifestFileRefsResult
extends SasManifestResult {
    private List<ManifestFileRef> fileRefs = new ArrayList<ManifestFileRef>();
    private JobManifestService.ManifestListType listType;

    public void setFileRefs(Manifest manifest, JobManifestService.ManifestListType listType, List<? extends ManifestFileRef> manifestFileRefs) {
        this.setManifest(manifest);
        this.listType = listType;
        this.fileRefs.addAll(manifestFileRefs);
    }

    public int getSize() {
        return this.fileRefs.size();
    }

    public List<? extends ManifestFileRef> getFileRefs() {
        return this.fileRefs;
    }

    public String getListType() {
        return this.listType.name();
    }

    public ManifestFileRef getFileRef(double index) {
        return this.fileRefs.get((int)index);
    }

    public String getPath(double index) {
        return this.fileRefs.get((int)index).getPath();
    }

    public String getName(double index) {
        return this.fileRefs.get((int)index).getName();
    }

    public String getVersion(double index) {
        return this.fileRefs.get((int)index).getVersion();
    }

    public String getSourceLocation(double index) {
        return SasManifestFileRefsResult.getManifestFileSourceLocation(this.fileRefs.get((int)index));
    }

    public String getLastModified(double index) {
        return SasUtils.toSasString(this.fileRefs.get((int)index).getLastModified());
    }

    public long getFileSize(double index) {
        return this.fileRefs.get((int)index).getFile().getSize();
    }

    public String getFormattedFileSize(double index) {
        return SasUtils.toSasFormattedFileSize(this.getFileSize(index));
    }

    public static String getManifestFileSourceLocation(ManifestFileRef mfr) {
        if (mfr.isRepositoryFile()) {
            return SourceLocation.REPOSITORY.name();
        }
        return SourceLocation.WORKSPACE.name();
    }
}

