/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobmanifest;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.JobSubmission;
import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestFile;
import com.sas.lsaf.execution.job.ManifestFileRef;
import com.sas.lsaf.execution.job.ManifestJob;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.execution.job.JobUtils;
import com.sas.lsaf.macro.execution.jobmanifest.SasJobManifestProperty;
import java.util.ArrayList;
import java.util.List;

public class SasJobManifestInfoHelper {
    private static List<SasJobManifestProperty> manifestProperties = new ArrayList<SasJobManifestProperty>();
    private static Manifest manifest;
    private static ManifestFile manifestFile;
    private static ManifestRecordType recordType;

    private static void setManifest(Manifest m) {
        manifest = m;
        manifestFile = manifest.getManifest();
    }

    private static void doAddDetail(String name, String value) {
        manifestProperties.add(new SasJobManifestProperty(recordType, name, value));
    }

    private static void doAddManifestDetails() {
        recordType = ManifestRecordType.MANIFEST;
        SasJobManifestInfoHelper.doAddDetail("manifestType", manifest.getManifestType().name());
        SasJobManifestInfoHelper.doAddDetail("manifestName", manifestFile.getName());
        SasJobManifestInfoHelper.doAddDetail("manifestLastModified", SasUtils.toSasDatetimeFormat(manifestFile.getLastModified()));
        Long size = manifestFile.getSize();
        SasJobManifestInfoHelper.doAddDetail("manifestSize", SasUtils.toSasString(size));
        SasJobManifestInfoHelper.doAddDetail("manifestSizeFormatted", SasUtils.toSasFormattedFileSize(size));
    }

    private static void doAddJobDetails() {
        recordType = ManifestRecordType.JOB;
        ManifestJob mnfJob = manifest.getJob();
        SourceLocation jobSrcLocation = SasJobManifestInfoHelper.getManifestFileSourceLocation((ManifestFileRef)mnfJob);
        List<SasProperty> mnfProps = JobUtils.getJobProperties(jobSrcLocation, mnfJob.getPath(), mnfJob.getVersion(), manifest.getOutputFileSpec());
        for (SasProperty sp : mnfProps) {
            SasJobManifestInfoHelper.doAddDetail(sp.getName(), sp.getValue());
        }
    }

    private static void doAddSubmissionDetails() {
        recordType = ManifestRecordType.SUBMISSION;
        JobSubmission js = manifest.getJobSubmission();
        if (js == null) {
            return;
        }
        SasJobManifestInfoHelper.doAddDetail("submittedBy", SasUtils.toSasString(js.getSubmittedBy()));
        SasJobManifestInfoHelper.doAddDetail("runAsUser", SasUtils.toSasString(js.getRunAsUser()));
        SasJobManifestInfoHelper.doAddDetail("submitted", SasUtils.toSasDatetimeFormat(js.getSubmitted()));
        SasJobManifestInfoHelper.doAddDetail("completed", SasUtils.toSasDatetimeFormat(js.getCompleted()));
        SasJobManifestInfoHelper.doAddDetail("sessionId", SasUtils.toSasString(js.getSessionId()));
        JobSubmissionStatus jsStat = js.getJobSubmissionStatus();
        SasJobManifestInfoHelper.doAddDetail("summaryStatus", SasUtils.toSasString(jsStat.getSummaryStatus()));
        SasJobManifestInfoHelper.doAddDetail("detailStatus", SasUtils.toSasString(jsStat.getDetailStatus()));
        SasJobManifestInfoHelper.doAddDetail("statusMsg", SasUtils.toSasString(jsStat.getStatusMessage()));
    }

    public static SourceLocation getManifestFileSourceLocation(ManifestFileRef mfr) {
        return mfr.isRepositoryFile() ? SourceLocation.REPOSITORY : SourceLocation.WORKSPACE;
    }

    public static List<SasJobManifestProperty> toSasManfestInfo(Manifest manifest) {
        manifestProperties.clear();
        SasJobManifestInfoHelper.setManifest(manifest);
        SasJobManifestInfoHelper.doAddManifestDetails();
        SasJobManifestInfoHelper.doAddJobDetails();
        SasJobManifestInfoHelper.doAddSubmissionDetails();
        return manifestProperties;
    }

    static {
        recordType = ManifestRecordType.MANIFEST;
    }

    public static enum ManifestRecordType {
        MANIFEST,
        JOB,
        SUBMISSION;

    }
}

