/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.jobmanifest;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.JobSubmissionService;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestExternalReference;
import com.sas.lsaf.execution.job.ResultsNotFoundException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.jobmanifest.SasJobManifestInfoResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestExternalReference;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestExternalReferencesResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestInputsResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestJobResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestMetricsResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestOutputsResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestProgramsResult;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestSystemFilesResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JobManifestService {
    private static Log LOG = LogFactory.getLog(JobManifestService.class);
    private static JobManifestService FOR_COVERAGE = new JobManifestService();

    private static JobSubmissionService doGetService() {
        return ServiceManagerFactory.getApiJobSubmissionService();
    }

    private static Manifest doGetManifestByPath(String srcLoc, String path, String version) throws ResultsNotFoundException {
        SourceLocation sl = (SourceLocation)ValidationUtils.validateUpcasedEnum(srcLoc, "Manifest location", SourceLocation.class);
        ValidationUtils.assertRequiredPath(path);
        return SourceLocation.REPOSITORY.equals((Object)sl) ? JobManifestService.doGetService().getManifestByRepositoryPath(path, version) : JobManifestService.doGetService().getManifestByWorkspacePath(path);
    }

    private static List<SasManifestExternalReferencesResult.ManifestExtRefType> doGetExternalReferenceTypes(String type) {
        SasManifestExternalReferencesResult.ManifestExtRefType[] extTypes = SasManifestExternalReferencesResult.ManifestExtRefType.values();
        if (ValidationUtils.valueIsMissing((Serializable)((Object)type))) {
            return Arrays.asList(extTypes);
        }
        ArrayList<SasManifestExternalReferencesResult.ManifestExtRefType> types = new ArrayList<SasManifestExternalReferencesResult.ManifestExtRefType>();
        try {
            SasManifestExternalReferencesResult.ManifestExtRefType mt = SasManifestExternalReferencesResult.ManifestExtRefType.valueOf(type.trim().toUpperCase());
            types.add(mt);
        }
        catch (IllegalArgumentException e) {
            String validValues = SasUtils.toSasCommaDelimitedString(EnumUtils.getEnumList(SasManifestExternalReferencesResult.ManifestExtRefType.class));
            ValidationUtils.handleInvalidParameterValue(validValues, "External reference type");
        }
        return types;
    }

    private static List<SasManifestExternalReference> doGetSasExternalRefsFromManifestList(SasManifestExternalReferencesResult.ManifestExtRefType type, List<ManifestExternalReference> extRefs) {
        ArrayList<SasManifestExternalReference> refs = new ArrayList<SasManifestExternalReference>();
        for (ManifestExternalReference mer : extRefs) {
            SasManifestExternalReference smr = new SasManifestExternalReference(type.name(), mer);
            refs.add(smr);
        }
        return refs;
    }

    public static void getJobManifestMetricsByPath(String srcLoc, String path, String version, SasManifestMetricsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest metrics for " + path + ", version" + version));
        }
        try {
            result.setMetrics(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestInfo(String srcLoc, String path, String version, SasJobManifestInfoResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest info for " + path + ", version" + version));
        }
        try {
            result.setJobManifestInfo(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestInputs(String srcLoc, String path, String version, SasManifestInputsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest inputs for " + path + ", version" + version));
        }
        try {
            result.setManifestInputs(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestOutputs(String srcLoc, String path, String version, SasManifestOutputsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest outputs for " + path + ", version" + version));
        }
        try {
            result.setManifestOutputs(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestPrograms(String srcLoc, String path, String version, SasManifestProgramsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest programs for " + path + ", version" + version));
        }
        try {
            result.setManifestPrograms(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestParameters(String srcLoc, String path, String version, SasManifestJobResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest parameters for " + path + ", version" + version));
        }
        try {
            result.setManifestParameters(JobManifestService.doGetManifestByPath(srcLoc, path, version));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestLogs(String srcLoc, String path, String version, SasManifestSystemFilesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest logs for " + path + ", version" + version));
        }
        try {
            Manifest m = JobManifestService.doGetManifestByPath(srcLoc, path, version);
            result.setFileRefs(m, ManifestListType.LOGS, m.getLogs());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestResults(String srcLoc, String path, String version, SasManifestSystemFilesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest results for " + path + ", version" + version));
        }
        try {
            Manifest m = JobManifestService.doGetManifestByPath(srcLoc, path, version);
            result.setFileRefs(m, ManifestListType.RESULTS, m.getResults());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getJobManifestExternalRefs(String srcLoc, String path, String version, String referenceType, SasManifestExternalReferencesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job manifest external file references for " + path + ", version" + version));
        }
        try {
            Manifest m = JobManifestService.doGetManifestByPath(srcLoc, path, version);
            List<SasManifestExternalReferencesResult.ManifestExtRefType> refTypes = JobManifestService.doGetExternalReferenceTypes(referenceType);
            ArrayList<SasManifestExternalReference> sasRefs = new ArrayList<SasManifestExternalReference>();
            if (refTypes.contains((Object)SasManifestExternalReferencesResult.ManifestExtRefType.INPUTS)) {
                sasRefs.addAll(JobManifestService.doGetSasExternalRefsFromManifestList(SasManifestExternalReferencesResult.ManifestExtRefType.INPUTS, m.getExternalInputs()));
            }
            if (refTypes.contains((Object)SasManifestExternalReferencesResult.ManifestExtRefType.OUTPUTS)) {
                sasRefs.addAll(JobManifestService.doGetSasExternalRefsFromManifestList(SasManifestExternalReferencesResult.ManifestExtRefType.OUTPUTS, m.getExternalOutputs()));
            }
            result.setReferences(m, sasRefs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static enum ManifestListType {
        PROGRAMS,
        INPUTS,
        OUTPUTS,
        LOGS,
        RESULTS;

    }
}

