/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.execution.job.JobParameter;
import java.util.ArrayList;
import java.util.List;

public class SasParameterValues {
    private List<SasParameterValue> parameterValues = new ArrayList<SasParameterValue>();

    public void setValues(List<SasParameterValue> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public List<SasParameterValue> getValues() {
        return this.parameterValues;
    }

    public int getSize() {
        return this.parameterValues.size();
    }

    public void clearList() {
        this.parameterValues.clear();
    }

    public void addValue(String name, String value, String type, String version, double includeSubfolders) {
        this.parameterValues.add(new SasParameterValue(name, value, type, version, (int)includeSubfolders));
    }

    public void addCharValue(String name, String value) {
        this.addValue(name, value, JobParameter.ParameterType.CHARACTER.name(), "", 0.0);
    }

    public void addNumValue(String name, String value) {
        this.addValue(name, value, JobParameter.ParameterType.NUMERIC.name(), "", 0.0);
    }

    public void addDateValue(String name, String value) {
        this.addValue(name, value, JobParameter.ParameterType.DATE.name(), "", 0.0);
    }

    public void addFileValue(String name, String value, String version) {
        this.addValue(name, value, JobParameter.ParameterType.FILE.name(), version, 0.0);
    }

    public void addFolderValue(String name, String value, double includeSubfolders) {
        this.addValue(name, value, JobParameter.ParameterType.FOLDER.name(), "", (int)includeSubfolders);
    }

    public void addMaskedValue(String name, String value) {
        this.addValue(name, value, JobParameter.ParameterType.CHARACTER_MASKED.name(), null, 0.0);
    }

    public class SasParameterValue {
        private String name;
        private String value;
        private String type;
        private String version;
        private int includeSubfolders;

        public SasParameterValue() {
        }

        public SasParameterValue(String name, String value, String type, String version, int includeSubfolders) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.version = version;
            this.includeSubfolders = includeSubfolders;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setIncludeSubfolders(int includeSubfolders) {
            this.includeSubfolders = includeSubfolders;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public int getIncludeSubfolders() {
            return this.includeSubfolders;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("SasParameterValue [");
            buf.append("Name: " + this.getName());
            buf.append(", Value: " + this.getValue());
            buf.append(", Type: " + this.getType());
            buf.append(", Version: " + this.getVersion());
            buf.append(", IncludeSubfolders: " + this.getIncludeSubfolders());
            return buf.toString();
        }
    }
}

