/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.macro.execution.job.SasJobItems;
import java.util.ArrayList;
import java.util.List;

public class SasJobPublishSetups
extends SasJobItems {
    public static final int DEFAULT_INCLUDE_FILES_AND_SUBFOLDERS = 0;
    private List<SasJobPublishSetup> items = new ArrayList<SasJobPublishSetup>();

    public void setJobItems(List<SasJobPublishSetup> jobItems) {
        this.items = jobItems;
    }

    public List<SasJobPublishSetup> getJobItems() {
        return this.items;
    }

    public int getSize() {
        return this.items.size();
    }

    public void addItem(SasJobPublishSetup item) {
        this.items.add(item);
    }

    public void addItem(String path, String type, String version, double includeSubfolders, double includeFiles) {
        this.addItem(new SasJobPublishSetup(path, type, version, (int)includeSubfolders, (int)includeFiles));
    }

    public void addFileItem(String path, String version) {
        this.addItem(new SasJobPublishSetup(path, ItemType.FILE.name(), version, 0, 0));
    }

    public void addContainerItem(String path, double includeSubfolders, double includeFiles) {
        this.addItem(new SasJobPublishSetup(path, ItemType.CONTAINER.name(), null, (int)includeSubfolders, (int)includeFiles));
    }

    public class SasJobPublishSetup {
        private String path;
        private String type;
        private String fileVersion;
        private int includeSubFolders = 0;
        private int includeFiles = 0;

        public SasJobPublishSetup() {
        }

        public SasJobPublishSetup(String path, String type, String fileVersion, int includeSubfolders, int includeFiles) {
            this.path = path;
            this.type = type;
            this.fileVersion = fileVersion;
            this.includeSubFolders = includeSubfolders;
            this.includeFiles = includeFiles;
        }

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }

        public String getFileVersion() {
            return this.fileVersion;
        }

        public int getIncludeSubFolders() {
            return this.includeSubFolders;
        }

        public int getIncludeFiles() {
            return this.includeFiles;
        }

        public void setPath(String value) {
            this.path = value;
        }

        public void setType(String value) {
            this.type = value;
        }

        public void setFileVersion(String value) {
            this.fileVersion = value;
        }

        public void setIncludeSubfolders(int value) {
            this.includeSubFolders = value;
        }

        public void setIncludeFiles(int value) {
            this.includeFiles = value;
        }

        public boolean isFile() {
            return this.getType().equals(ItemType.FILE.name());
        }
    }

    public static enum ItemType {
        FILE,
        CONTAINER;

    }
}

