/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.execution.JobParameterUtils;
import com.sas.lsaf.macro.execution.job.SasJobResult;
import java.util.ArrayList;
import java.util.List;

public class SasJobParametersResult
extends Result
implements SasJobResult {
    private String jobPath;
    private String jobVersion;
    private List<JobParameter> parameters = new ArrayList<JobParameter>();

    public void setJobParameters(String path, String version, List<JobParameter> params) {
        this.jobPath = path;
        this.jobVersion = version;
        this.parameters.addAll(params);
    }

    public int getSize() {
        return this.parameters.size();
    }

    public List<JobParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getJobPath() {
        return this.jobPath;
    }

    @Override
    public String getJobVersion() {
        return this.jobVersion;
    }

    public JobParameter getParameter(double index) {
        return this.parameters.get((int)index);
    }

    public String getName(double index) {
        return SasUtils.toSasString(this.parameters.get((int)index).getName());
    }

    public String getType(double index) {
        return SasUtils.toSasString(this.parameters.get((int)index).getType().toString());
    }

    public String getLabel(double index) {
        return SasUtils.toSasString(this.parameters.get((int)index).getLabel());
    }

    public String getDefaultValue(double index) {
        return JobParameterUtils.getJobParameterDefaultValue(this.parameters.get((int)index));
    }

    public String getFileVersion(double index) {
        return JobParameterUtils.getJobParameterFileVersion(this.parameters.get((int)index));
    }

    public String getContainerIncludeSubfolders(double index) {
        return JobParameterUtils.getJobParameterContainerIncludeSubfolders(this.parameters.get((int)index));
    }
}

