/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.execution.job.JobParameter;
import java.util.ArrayList;
import java.util.List;

public class SasJobParameters {
    private List<SasJobParameter> parameters = new ArrayList<SasJobParameter>();
    private String updateData = "0";

    public void setParameters(List<SasJobParameter> jobParms) {
        this.parameters = jobParms;
    }

    public List<SasJobParameter> getParameters() {
        return this.parameters;
    }

    public int getSize() {
        return this.parameters.size();
    }

    public boolean getUpdateData() {
        return this.updateData.equals("1");
    }

    public void setUpdateData(String ud) {
        this.updateData = ud;
    }

    public void addValue(String name, String label, String type, String value, String version, double includeSubfolders) {
        this.parameters.add(new SasJobParameter(name, label, type, value, version, (int)includeSubfolders));
    }

    public void addCharParameter(String name, String label, String value) {
        this.addValue(name, label, JobParameter.ParameterType.CHARACTER.name(), value, "", 0.0);
    }

    public void addNumParameter(String name, String label, String value) {
        this.addValue(name, label, JobParameter.ParameterType.NUMERIC.name(), value, "", 0.0);
    }

    public void addDateParamter(String name, String label, String value) {
        this.addValue(name, label, JobParameter.ParameterType.DATE.name(), value, "", 0.0);
    }

    public void addFileParameter(String name, String label, String value, String version) {
        this.addValue(name, label, JobParameter.ParameterType.FILE.name(), value, version, 0.0);
    }

    public void addFolderParameter(String name, String label, String value, double includeSubfolders) {
        this.addValue(name, label, JobParameter.ParameterType.FOLDER.name(), value, "", (int)includeSubfolders);
    }

    public void addMaskedParameter(String name, String label) {
        this.addValue(name, label, JobParameter.ParameterType.CHARACTER_MASKED.name(), "", null, 0.0);
    }

    public class SasJobParameter {
        private String name;
        private String label;
        private String type;
        private String defaultValue;
        private String version;
        private int includeSubfolders;

        public SasJobParameter() {
        }

        public SasJobParameter(String name, String label, String type, String defaultValue, String version, int includeSubfolders) {
            this.name = name;
            this.label = label;
            this.type = type;
            this.defaultValue = defaultValue;
            this.version = version;
            this.includeSubfolders = includeSubfolders;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setIncludeSubfolders(int includeSubfolders) {
            this.includeSubfolders = includeSubfolders;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getVersion() {
            return this.version;
        }

        public int getIncludeSubfolders() {
            return this.includeSubfolders;
        }
    }
}

