/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.JobFormatException;
import com.sas.lsaf.execution.job.JobNotFoundException;
import com.sas.lsaf.execution.job.JobProgram;
import com.sas.lsaf.execution.job.JobPublishCheckinLocation;
import com.sas.lsaf.execution.job.JobPublishSetup;
import com.sas.lsaf.execution.job.JobPublishSetupFile;
import com.sas.lsaf.execution.job.JobPublishSetupFolder;
import com.sas.lsaf.execution.job.JobService;
import com.sas.lsaf.execution.job.OutputFileSpec;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.JobParameterUtils;
import com.sas.lsaf.macro.execution.ValidatedSubmittableJob;
import com.sas.lsaf.macro.execution.job.SasJobPrograms;
import com.sas.lsaf.macro.execution.job.SasJobPublishCheckinLocations;
import com.sas.lsaf.macro.execution.job.SasJobPublishSetups;
import com.sas.lsaf.macro.execution.jobsubmission.SasSubmittableJob;
import com.sas.lsaf.macro.execution.schedule.SasSchedulableJob;
import java.util.ArrayList;
import java.util.List;

public final class JobUtils {
    private static JobUtils FOR_COVERAGE = new JobUtils();
    public static final String SPECTYPE_PROGRAMS = "programs";
    public static final String SPECTYPE_SETUP = "setup";
    public static final String SPECTYPE_CHECKIN_LOCATIONS = "checkinLocations";
    public static final String SPECTYPE_PARAMETERS = "parameters";

    private JobUtils() {
    }

    private static JobService doGetService() {
        return ServiceManagerFactory.getApiJobService();
    }

    public static ValidatedSubmittableJob getValidatedSubmittableJob(SasSubmittableJob job) {
        ValidatedSubmittableJob vj = new ValidatedSubmittableJob();
        vj.setPath(ValidationUtils.assertRequiredPath(job.getPath()));
        vj.setVersion(ValidationUtils.toJavaString(job.getVersion()));
        vj.setParameterValues(JobParameterUtils.toApiOverrideParameterValues(job.getParameterValues()));
        return vj;
    }

    public static ValidatedSubmittableJob getValidatedSchedulableJob(SasSchedulableJob job) {
        SourceLocation srcLoc = ValidationUtils.validateSourceLocation(job.getSourceLocation());
        ValidatedSubmittableJob vj = JobUtils.getValidatedSubmittableJob(job);
        vj.setSourceLocation(srcLoc);
        return vj;
    }

    public static Job getWorkspaceJob(String path) throws JobNotFoundException, JobFormatException {
        ValidationUtils.assertRequiredPath(path);
        return JobUtils.doGetService().getWorkspaceJob(path);
    }

    public static Job getRepositoryJob(String path, String version) throws JobNotFoundException, JobFormatException {
        ValidationUtils.assertRequiredPath(path);
        return JobUtils.doGetService().getRepositoryJob(path, version);
    }

    public static SasJobPrograms toPrograms(Job job) {
        SasJobPrograms items = new SasJobPrograms();
        List programs = job.getPrograms();
        for (JobProgram pgm : programs) {
            items.addItem(pgm.getPath(), pgm.getVersion());
        }
        return items;
    }

    public static SasJobPublishSetups toPublishSetupList(Job job) {
        SasJobPublishSetups items = new SasJobPublishSetups();
        JobPublishSetup setup = job.getPublishSetup();
        for (JobPublishSetupFile file : setup.getFiles()) {
            items.addFileItem(file.getPath(), file.getVersion());
        }
        for (JobPublishSetupFolder folder : setup.getFolders()) {
            items.addContainerItem(folder.getPath(), SasUtils.toSasInteger(folder.isIncludeSubfolders()), SasUtils.toSasInteger(folder.isIncludeFiles()));
        }
        return items;
    }

    public static SasJobPublishCheckinLocations toPublishCheckinLocations(Job job) {
        SasJobPublishCheckinLocations items = new SasJobPublishCheckinLocations();
        List locations = job.getPublishCheckin().getLocations();
        for (JobPublishCheckinLocation loc : locations) {
            items.addItem(loc.getPath(), SasUtils.toSasInteger(loc.isIncludeSubfolders()));
        }
        return items;
    }

    public static List<SasProperty> getJobProperties(SourceLocation srcLoc, String path, String version, OutputFileSpec ofs) {
        ArrayList<SasProperty> jobProperties = new ArrayList<SasProperty>();
        String jobVersion = SourceLocation.WORKSPACE.equals((Object)srcLoc) ? "WORKSPACE" : version;
        jobProperties.add(new SasProperty("sourceLocation", srcLoc.name()));
        jobProperties.add(new SasProperty("path", path));
        jobProperties.add(new SasProperty("name", PathUtils.getName(path)));
        jobProperties.add(new SasProperty("version", jobVersion));
        jobProperties.add(new SasProperty("newOutputs_enableVersion", SasUtils.toSasString(ofs.isEnableVersioningForNewFiles())));
        jobProperties.add(new SasProperty("newOutputs_versionType", ofs.getVersionType().name()));
        jobProperties.add(new SasProperty("newOutputs_customVersion", SasUtils.toSasString(ofs.getCustomVersion())));
        return jobProperties;
    }

    public static List<SasProperty> toJobSasProperties(Job job) {
        List<SasProperty> props = JobUtils.getJobProperties(job.getSourceLocation(), job.getPath(), job.getVersion(), (OutputFileSpec)job.getPublishCheckin());
        props.add(new SasProperty("documentation", job.getDescription()));
        props.add(new SasProperty("logsLocation", job.getLogsLocation()));
        props.add(new SasProperty("resultsLocation", job.getResultsLocation()));
        props.add(new SasProperty("manifestLocation", job.getManifestLocation()));
        return props;
    }
}

