/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution.job;

import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobPublishCheckin;
import com.sas.lsaf.execution.job.JobPublishCheckinLocation;
import com.sas.lsaf.execution.job.JobPublishSetup;
import com.sas.lsaf.execution.job.JobPublishSetupFile;
import com.sas.lsaf.execution.job.JobPublishSetupFolder;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.execution.JobParameterUtils;
import com.sas.lsaf.macro.execution.job.JobUtils;
import com.sas.lsaf.macro.execution.job.SasJobInfo;
import com.sas.lsaf.macro.execution.job.SasJobItemParameterRequiredException;
import com.sas.lsaf.macro.execution.job.SasJobParameters;
import com.sas.lsaf.macro.execution.job.SasJobParametersResult;
import com.sas.lsaf.macro.execution.job.SasJobPrograms;
import com.sas.lsaf.macro.execution.job.SasJobProgramsResult;
import com.sas.lsaf.macro.execution.job.SasJobPropertiesResult;
import com.sas.lsaf.macro.execution.job.SasJobPublishCheckinLocations;
import com.sas.lsaf.macro.execution.job.SasJobPublishCheckinLocationsResult;
import com.sas.lsaf.macro.execution.job.SasJobPublishSetups;
import com.sas.lsaf.macro.execution.job.SasJobPublishSetupsResult;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JobService {
    private static Log LOG = LogFactory.getLog(JobService.class);
    private static JobService FOR_COVERAGE = new JobService();

    private JobService() {
    }

    private static String doGetRepositoryJobVersion(Job job) {
        String version = job.getVersion();
        return version == null ? "" : version;
    }

    private static com.sas.lsaf.execution.job.JobService doGetService() {
        return ServiceManagerFactory.getApiJobService();
    }

    private static JobPublishCheckin doGetPublishCheckin(SasJobInfo info) {
        JobPublishCheckin jpc = new JobPublishCheckin();
        String infoVersioning = info.getEnableVersioning();
        if (infoVersioning != null) {
            boolean versioning = ValidationUtils.validateBinaryFlagDefaultFalse(infoVersioning, "Versioning");
            jpc.setEnableVersioningForNewFiles(versioning);
        }
        String infoVersionType = info.getVersionType();
        String infoCustomVersion = info.getCustomVersion();
        if (infoVersionType != null) {
            VersionType vType = ContentCreationParametersHelper.validateVersionTypeWithCustom(info.getVersionType(), infoCustomVersion);
            jpc.setVersionType(vType);
        }
        if (infoCustomVersion != null) {
            jpc.setCustomVersion(infoCustomVersion);
        }
        return jpc;
    }

    private static void doUpdateJob(Job job, SasJobInfo jobInfo, SasJobPrograms programs, SasJobParameters params, SasJobPublishSetups publishSetup, SasJobPublishCheckinLocations publishCheckinLocations, boolean creatingJob) {
        JobService.doUpdateJobFromInfo(job, jobInfo);
        if (programs != null && (creatingJob || programs.getUpdateData())) {
            JobService.doSetJobPrograms(job, programs);
        }
        if (params != null && (creatingJob || params.getUpdateData())) {
            JobService.doSetJobParameters(job, params);
        }
        if (publishSetup != null && (creatingJob || publishSetup.getUpdateData())) {
            JobService.doSetJobPublishSetup(job, publishSetup);
        }
        if (publishCheckinLocations != null && (creatingJob || publishCheckinLocations.getUpdateData())) {
            JobService.doSetJobPublishCheckinLocations(job, publishCheckinLocations);
        }
    }

    private static void doUpdateJobFromInfo(Job job, SasJobInfo jobInfo) {
        if (jobInfo == null) {
            return;
        }
        if (jobInfo.getDescription() != null) {
            job.setDescription(jobInfo.getDescription());
        }
        if (jobInfo.getLogsLocation() != null) {
            job.setLogsLocation(jobInfo.getLogsLocation());
        }
        if (jobInfo.getResultsLocation() != null) {
            job.setResultsLocation(jobInfo.getResultsLocation());
        }
        if (jobInfo.getManifestLocation() != null) {
            job.setManifestLocation(jobInfo.getManifestLocation());
        }
        job.setPublishCheckin(JobService.doGetPublishCheckin(jobInfo));
    }

    private static void doSetJobPrograms(Job job, SasJobPrograms items) {
        job.getPrograms().clear();
        for (SasJobPrograms.SasJobProgram pgm : items.getJobPrograms()) {
            String pgmPath = pgm.getPath();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)pgmPath))) {
                throw new SasJobItemParameterRequiredException("Path", "programs");
            }
            job.addProgram(pgmPath, pgm.getFileVersion());
        }
    }

    private static void doSetJobParameters(Job job, SasJobParameters sjParameters) {
        job.getParameters().clear();
        for (SasJobParameters.SasJobParameter sasjp : sjParameters.getParameters()) {
            String defValue;
            JobParameter.ParameterType parmType = ValidationUtils.validateJobParameterType(sasjp.getType());
            String parmName = sasjp.getName() == null ? null : sasjp.getName().trim();
            String parmLabel = sasjp.getLabel() == null ? null : sasjp.getLabel().trim();
            String string = defValue = ValidationUtils.valueIsMissing((Serializable)((Object)sasjp.getDefaultValue())) ? null : sasjp.getDefaultValue().trim();
            if (parmType.equals((Object)JobParameter.ParameterType.CHARACTER)) {
                job.addCharacterParameter(parmName, parmLabel, defValue);
                continue;
            }
            if (parmType.equals((Object)JobParameter.ParameterType.CHARACTER_MASKED)) {
                job.addCharacterMaskedParameter(parmName, parmLabel, defValue);
                continue;
            }
            if (parmType.equals((Object)JobParameter.ParameterType.NUMERIC)) {
                job.addNumericParameter(parmName, parmLabel, defValue);
                continue;
            }
            if (parmType.equals((Object)JobParameter.ParameterType.DATE)) {
                job.addDateParameter(parmName, parmLabel, ValidationUtils.validateDateString(parmName, defValue));
                continue;
            }
            if (parmType.equals((Object)JobParameter.ParameterType.FILE)) {
                job.addFileParameter(parmName, parmLabel, defValue, sasjp.getVersion());
                continue;
            }
            if (!parmType.equals((Object)JobParameter.ParameterType.FOLDER)) continue;
            job.addFolderParameter(parmName, parmLabel, defValue, JobParameterUtils.validateIncludeSubfolders(sasjp.getIncludeSubfolders()));
        }
    }

    private static void doSetJobPublishSetup(Job job, SasJobPublishSetups items) {
        job.getPublishSetup().getFiles().clear();
        job.getPublishSetup().getFolders().clear();
        JobPublishSetup jps = new JobPublishSetup();
        ArrayList<JobPublishSetupFile> files = new ArrayList<JobPublishSetupFile>();
        ArrayList<JobPublishSetupFolder> folders = new ArrayList<JobPublishSetupFolder>();
        for (SasJobPublishSetups.SasJobPublishSetup setupItem : items.getJobItems()) {
            String setupPath = setupItem.getPath();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)setupPath))) {
                throw new SasJobItemParameterRequiredException("Path", "setup");
            }
            SasJobPublishSetups.ItemType iType = (SasJobPublishSetups.ItemType)ValidationUtils.validateUpcasedEnum(setupItem.getType(), "Job setup item type", SasJobPublishSetups.ItemType.class);
            if (iType.equals((Object)SasJobPublishSetups.ItemType.CONTAINER)) {
                boolean includeFiles = JobParameterUtils.validateIncludeFiles(setupItem.getIncludeFiles());
                boolean includeSubFolders = JobParameterUtils.validateIncludeSubfolders(setupItem.getIncludeSubFolders());
                JobPublishSetupFolder folder = new JobPublishSetupFolder(setupPath, includeFiles, includeSubFolders);
                folders.add(folder);
                continue;
            }
            String fileVersion = setupItem.getFileVersion();
            JobPublishSetupFile file = new JobPublishSetupFile(setupPath, fileVersion);
            files.add(file);
        }
        jps.setFiles(files);
        jps.setFolders(folders);
        job.setPublishSetup(jps);
    }

    private static void doSetJobPublishCheckinLocations(Job job, SasJobPublishCheckinLocations items) {
        job.getPublishCheckin().getLocations().clear();
        ArrayList<JobPublishCheckinLocation> locations = new ArrayList<JobPublishCheckinLocation>();
        for (SasJobPublishCheckinLocations.SasJobPublishCheckinLocation loc : items.getJobItems()) {
            String locPath = loc.getPath();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)locPath))) {
                throw new SasJobItemParameterRequiredException("Path", "checkinLocations");
            }
            boolean includeSubFolders = JobParameterUtils.validateIncludeSubfolders(loc.getIncludeSubFolders());
            JobPublishCheckinLocation location = new JobPublishCheckinLocation(locPath, includeSubFolders);
            locations.add(location);
        }
        job.getPublishCheckin().setLocations(locations);
    }

    public static String createWorkspaceJob(String path, String useRelativePaths, SasJobInfo jobInfo, SasJobPrograms programs, SasJobParameters params, SasJobPublishSetups publishSetup, SasJobPublishCheckinLocations publishCheckinLocations, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create job in the workspace " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            boolean urp = ValidationUtils.validateBinaryFlagDefaultTrue(useRelativePaths, "Use relative path");
            Job job = new Job(path, null);
            JobService.doUpdateJob(job, jobInfo, programs, params, publishSetup, publishCheckinLocations, true);
            Job newJob = JobService.doGetService().createWorkspaceJob(job, true, urp);
            result.init(0, "Success.");
            return newJob.getPath();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return null;
        }
    }

    public static void updateWorkspaceJob(String path, SasJobInfo jobInfo, SasJobPrograms programs, SasJobParameters params, SasJobPublishSetups publishSetup, SasJobPublishCheckinLocations publishCheckinLocations, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Update job in the workspace " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            JobService.doUpdateJob(job, jobInfo, programs, params, publishSetup, publishCheckinLocations, false);
            JobService.doGetService().updateWorkspaceJob(job);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getWorkspaceJobInfo(String path, SasJobPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting workspace job " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            result.setJobProperties(job.getPath(), "WORKSPACE", JobUtils.toJobSasProperties(job));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getWorkspaceJobPrograms(String path, SasJobProgramsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting programs for workspace job " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            SasJobPrograms items = JobUtils.toPrograms(job);
            result.setJobPrograms(path, "WORKSPACE", items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getWorkspaceJobParameters(String path, SasJobParametersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting parameters for workspace job " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            result.setJobParameters(job.getPath(), "WORKSPACE", job.getParameters());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getWorkspaceJobSetup(String path, SasJobPublishSetupsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting workspace job setup " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            SasJobPublishSetups items = JobUtils.toPublishSetupList(job);
            result.setJobSetups(path, "WORKSPACE", items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getWorkspaceJobCheckinLocations(String path, SasJobPublishCheckinLocationsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting checkin locations for workspace job " + path));
        }
        try {
            Job job = JobUtils.getWorkspaceJob(path);
            SasJobPublishCheckinLocations items = JobUtils.toPublishCheckinLocations(job);
            result.setJobCheckinLocations(path, "WORKSPACE", items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRepositoryJobInfo(String path, String version, SasJobPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job " + path + ", version=" + version));
        }
        try {
            Job job = JobUtils.getRepositoryJob(path, version);
            result.setJobProperties(job.getPath(), JobService.doGetRepositoryJobVersion(job), JobUtils.toJobSasProperties(job));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRepositoryJobParameters(String path, String version, SasJobParametersResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting parameters for job " + path + ", version=" + version));
        }
        try {
            Job job = JobUtils.getRepositoryJob(path, version);
            result.setJobParameters(job.getPath(), JobService.doGetRepositoryJobVersion(job), job.getParameters());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRepositoryJobPrograms(String path, String version, SasJobProgramsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting programs for job " + path + ", version=" + version));
        }
        try {
            Job job = JobUtils.getRepositoryJob(path, version);
            SasJobPrograms items = JobUtils.toPrograms(job);
            result.setJobPrograms(path, JobService.doGetRepositoryJobVersion(job), items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRepositoryJobSetup(String path, String version, SasJobPublishSetupsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting inputs for job " + path + ", version=" + version));
        }
        try {
            Job job = JobUtils.getRepositoryJob(path, version);
            SasJobPublishSetups items = JobUtils.toPublishSetupList(job);
            result.setJobSetups(path, JobService.doGetRepositoryJobVersion(job), items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getRepositoryJobCheckinLocations(String path, String version, SasJobPublishCheckinLocationsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting outputs for job " + path + ", version=" + version));
        }
        try {
            Job job = JobUtils.getRepositoryJob(path, version);
            SasJobPublishCheckinLocations items = JobUtils.toPublishCheckinLocations(job);
            result.setJobCheckinLocations(path, JobService.doGetRepositoryJobVersion(job), items);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setJobRunAsOwner(String path, String runAsOwner, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting runAsOwner for job " + path + " to " + runAsOwner));
        }
        try {
            ValidationUtils.validateRequiredParameter(path, "Path");
            boolean rao = ValidationUtils.validateBinaryFlagRequired(runAsOwner, "Run as owner");
            JobService.doGetService().setRunAsOwner(path, rao);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getJobRunAsOwner(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job runAsOwner: " + path));
        }
        try {
            ValidationUtils.validateRequiredParameter(path, "Path");
            result.init(0, "Success.");
            return SasUtils.toSasString(JobService.doGetService().getRunAsOwner(path));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }
}

