/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.execution;

import com.sas.lsaf.execution.job.JobInputFile;
import com.sas.lsaf.execution.job.JobInputFolder;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.execution.job.SasParameterValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobParameterUtils {
    private static JobParameterUtils FOR_COVERAGE = new JobParameterUtils();

    public static boolean validateIncludeSubfolders(int value) {
        return ValidationUtils.validateBinaryFlagDefaultFalse(Integer.valueOf(value).toString(), "Include subfolders");
    }

    public static boolean validateIncludeFiles(int value) {
        return ValidationUtils.validateBinaryFlagDefaultFalse(Integer.valueOf(value).toString(), "Include files");
    }

    public static List<ParameterValue> toApiOverrideParameterValues(SasParameterValues parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        for (SasParameterValues.SasParameterValue spv : parameters.getValues()) {
            String value;
            String type = ValidationUtils.validateJobParameterType(spv.getType()).name();
            String name = spv.getName();
            String spvValue = spv.getValue();
            String string = value = ValidationUtils.valueIsMissing((Serializable)((Object)spvValue)) ? null : spvValue.trim();
            if (JobParameter.ParameterType.CHARACTER.name().equals(type)) {
                parameterValues.add(new ParameterValue(name, (Serializable)((Object)value), JobParameter.ParameterType.CHARACTER));
                continue;
            }
            if (JobParameter.ParameterType.CHARACTER_MASKED.name().equals(type)) {
                parameterValues.add(new ParameterValue(name, (Serializable)((Object)value), JobParameter.ParameterType.CHARACTER_MASKED));
                continue;
            }
            if (JobParameter.ParameterType.NUMERIC.name().equals(type)) {
                parameterValues.add(new ParameterValue(name, (Serializable)((Object)value), JobParameter.ParameterType.NUMERIC));
                continue;
            }
            if (JobParameter.ParameterType.DATE.name().equals(type)) {
                parameterValues.add(new ParameterValue(name, (Serializable)ValidationUtils.validateDateString(name, value), JobParameter.ParameterType.DATE));
                continue;
            }
            if (JobParameter.ParameterType.FILE.name().equalsIgnoreCase(type)) {
                JobInputFile inputFile = ValidationUtils.valueIsMissing((Serializable)((Object)value)) ? null : new JobInputFile(value, spv.getVersion());
                parameterValues.add(new ParameterValue(name, (Serializable)inputFile, JobParameter.ParameterType.FILE));
                continue;
            }
            if (!JobParameter.ParameterType.FOLDER.toString().equalsIgnoreCase(type)) continue;
            boolean isf = JobParameterUtils.validateIncludeSubfolders(spv.getIncludeSubfolders());
            JobInputFolder inputFolder = ValidationUtils.valueIsMissing((Serializable)((Object)value)) ? null : new JobInputFolder(value, isf);
            parameterValues.add(new ParameterValue(name, (Serializable)inputFolder, JobParameter.ParameterType.FOLDER));
        }
        return parameterValues;
    }

    public static String getJobParameterDefaultValue(JobParameter jp) {
        return SasUtils.toSasFormattedString(jp.getDefaultValue());
    }

    public static String getParameterValue(ParameterValue pv) {
        return SasUtils.toSasFormattedString(pv.getValue());
    }

    public static String doGetParameterFileVersion(Serializable ser) {
        if (ser instanceof JobInputFile) {
            return ((JobInputFile)ser).getVersion();
        }
        return "";
    }

    public static String getJobParameterFileVersion(JobParameter jp) {
        return JobParameterUtils.doGetParameterFileVersion(jp.getDefaultValue());
    }

    public static String getParameterValueFileVersion(ParameterValue pv) {
        return JobParameterUtils.doGetParameterFileVersion(pv.getValue());
    }

    public static String getJobParameterContainerIncludeSubfolders(JobParameter jp) {
        return JobParameterUtils.getContainerIncludeSubfolders(jp.getDefaultValue());
    }

    public static int getParameterValueContainerIncludeSubfolders(ParameterValue pv) {
        String inclSubs = JobParameterUtils.getContainerIncludeSubfolders(pv.getValue());
        return "1".equals(inclSubs) ? 1 : 0;
    }

    public static String getContainerIncludeSubfolders(Serializable ser) {
        if (ser instanceof JobInputFolder) {
            boolean isIncludeSubs = ((JobInputFolder)ser).isIncludeSubfolders();
            return SasUtils.toSasString(isIncludeSubs);
        }
        return "0";
    }
}

