/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.utility;

import com.sas.lsaf.client.utils.RelativePathUtility;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.core.utility.PathFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UtilityService {
    private static Log LOG = LogFactory.getLog(UtilityService.class);
    private static UtilityService FOR_COVERAGE = new UtilityService();

    private UtilityService() {
    }

    private static void doValidateAbsolutePath(String value) {
        ValidationUtils.validateRequiredParameter(value, "Absolute path");
        if (!PathUtils.pathIsAbsolute(value)) {
            throw new PathFormatException(PathFormatException.PathType.ABSOLUTE);
        }
    }

    private static void doValidateBasePath(String value) {
        ValidationUtils.validateRequiredParameter(value, "Base path");
        if (PathUtils.pathIsRelative(value)) {
            throw new PathFormatException(PathFormatException.PathType.BASE);
        }
    }

    private static void doValidateRelativePath(String value) {
        ValidationUtils.validateRequiredParameter(value, "Relative path");
        if (!PathUtils.pathIsRelative(value)) {
            throw new PathFormatException(PathFormatException.PathType.RELATIVE);
        }
    }

    public static String getRelativePath(String basePath, String absolutePath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get relative path for " + absolutePath + " based on " + basePath));
        }
        try {
            UtilityService.doValidateBasePath(basePath);
            UtilityService.doValidateAbsolutePath(absolutePath);
            String rp = RelativePathUtility.getRelativePath((String)basePath, (String)absolutePath);
            result.init(0, "Success.");
            return rp;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getAbsolutePath(String basePath, String relativePath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get absolute path for " + relativePath + " based on " + basePath));
        }
        try {
            UtilityService.doValidateBasePath(basePath);
            UtilityService.doValidateRelativePath(relativePath);
            String ap = RelativePathUtility.getAbsolutePath((String)basePath, (String)relativePath);
            result.init(0, "Success.");
            return ap;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }
}

