/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.type;

import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.core.type.SasType;
import com.sas.lsaf.macro.core.type.SasTypeAttributeDefinition;
import com.sas.lsaf.macro.core.type.SasTypeAttributeDefinitionsResult;
import com.sas.lsaf.macro.core.type.SasTypesResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TypeService {
    private static final Log LOG = LogFactory.getLog(TypeService.class);
    public static final String LISTTYPE_ALL = "All";
    public static final String LISTTYPE_CONTEXT = "Contexts";
    public static final String LISTTYPE_ALLOWABLECHILDREN = "Type allowable children";
    public static final String LISTTYPE_TYPES_WITH_CAPABILITY = "Types with capability: ";
    public static final String LISTTYPE_AUDITABLE = "Auditable";
    public static final String LISTTYPE_SEARCHABLE = "Searchable";
    private static List<Type> allTypes;
    private static List<Type> auditableTypes;
    private static List<Type> contextTypes;
    private static List<Type> searchableTypes;
    private static TypeService FOR_COVERAGE;

    private TypeService() {
    }

    private static com.sas.lsaf.core.type.TypeService doGetService() {
        return ServiceManagerFactory.getApiTypeService();
    }

    private static Type.Capability doValidateCapabilty(String value) {
        return (Type.Capability)ValidationUtils.validateUpcasedEnum(value, "Capability", Type.Capability.class);
    }

    private static List<SasTypeAttributeDefinition> doGetExtendedAttrDefsFromType(Type type) {
        ArrayList<SasTypeAttributeDefinition> attribs = new ArrayList<SasTypeAttributeDefinition>();
        for (AttributeDefinition def : type.getAttributeDefinitions()) {
            if (!def.isExtended()) continue;
            attribs.add(new SasTypeAttributeDefinition(type, def));
        }
        return attribs;
    }

    public static void getAllTypes(SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting all LSAF item types");
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            if (allTypes == null) {
                allTypes = TypeService.doGetService().getTypes();
            }
            List<SasType> scts = SasType.toSasTypes(allTypes);
            result.setTypes(scts, LISTTYPE_ALL);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean typeExists(String typeId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Does type exist? " + typeId));
        }
        try {
            ValidationUtils.assertRequiredType(typeId);
            boolean exists = TypeService.doGetService().typeExists(typeId);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getAuditableTypes(SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting auditable types");
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            if (auditableTypes == null) {
                auditableTypes = TypeService.doGetService().getAuditableTypes();
            }
            List<SasType> scts = SasType.toSasTypes(auditableTypes);
            result.setTypes(scts, LISTTYPE_AUDITABLE);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getSearchableTypes(SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting searchable types");
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            if (searchableTypes == null) {
                searchableTypes = TypeService.doGetService().getSearchableTypes();
            }
            List<SasType> scts = SasType.toSasTypes(searchableTypes);
            result.setTypes(scts, LISTTYPE_SEARCHABLE);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getContextTypes(SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting context types");
        }
        try {
            ValidationUtils.validateHaveLsafSession();
            if (contextTypes == null) {
                contextTypes = TypeService.doGetService().getContextTypes();
            }
            List<SasType> scts = SasType.toSasTypes(contextTypes);
            result.setTypes(scts, LISTTYPE_CONTEXT);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isContextType(String typeId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is type a context " + typeId));
        }
        try {
            ValidationUtils.assertRequiredType(typeId);
            Type t = TypeService.doGetService().getTypeById(typeId);
            result.init(0, "Success.");
            return t.isContextType();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean typeHasCapability(String typeId, String capability, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Does type " + typeId + " have capability " + capability));
        }
        try {
            ValidationUtils.assertRequiredType(typeId);
            ValidationUtils.validateHaveLsafSession();
            Type.Capability cap = TypeService.doValidateCapabilty(capability);
            boolean hasCap = TypeService.doGetService().isTypeCapable(typeId, cap);
            result.init(0, "Success.");
            return hasCap;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getTypesByCapability(String capability, SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting LSAF types by " + capability));
        }
        try {
            Type.Capability cap = TypeService.doValidateCapabilty(capability);
            List typesWithCap = TypeService.doGetService().getTypesByCapability(cap);
            List<SasType> sasTypes = SasType.toSasTypes(typesWithCap);
            result.setTypes(sasTypes, LISTTYPE_TYPES_WITH_CAPABILITY + cap.name());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAllowableChildTypes(String typeId, SasTypesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting allowable children for type " + typeId));
        }
        try {
            ValidationUtils.assertRequiredType(typeId);
            Type parentType = TypeService.doGetService().getTypeById(typeId);
            ArrayList<Type> acts = new ArrayList<Type>(parentType.getAllowableChildTypes().size());
            for (String ctId : parentType.getAllowableChildTypes()) {
                Type childType = TypeService.doGetService().getTypeById(ctId);
                acts.add(childType);
            }
            List<SasType> sots = SasType.toSasTypes(acts);
            result.setTypes(sots, LISTTYPE_ALLOWABLECHILDREN);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTypeExtendedAttributes(String typeId, SasTypeAttributeDefinitionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting extended attribute info for type " + typeId));
        }
        try {
            if (ValidationUtils.valueIsMissing((Serializable)((Object)typeId))) {
                ArrayList<SasTypeAttributeDefinition> allTypeAttrs = new ArrayList<SasTypeAttributeDefinition>();
                List types = TypeService.doGetService().getTypes();
                for (Type t : types) {
                    allTypeAttrs.addAll(TypeService.doGetExtendedAttrDefsFromType(t));
                }
                result.setSasAttributeDefinitions(allTypeAttrs);
            } else {
                Type t = TypeService.doGetService().getTypeById(typeId);
                result.setSasAttributeDefinitions(TypeService.doGetExtendedAttrDefsFromType(t));
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    static {
        FOR_COVERAGE = new TypeService();
    }
}

